/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.du;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.du.DUVersion;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class DU {
    private String DELIVERY_UNIT;
    private String VERSION;
    private String VERSION_SP;
    private String VERSION_PATCH;
    private String PPMS_ID = "";
    private String CAPTION = "";
    private DUVersion duVersion;
    private String type = "";
    public static String DU = "delivery unit";
    public static String PLUGIN = "plugin";
    public static String HANA_UMML = "HANA_UMML";
    public static String LCAPPS = "lcapps";

    public DU(String du, String version, String sp, String patch, String ppms, String caption) {
        this(du, version, sp, patch);
        this.setPPMS_ID(ppms);
        this.setCAPTION(caption);
    }

    public DU(String du, String version, String sp, String patch) {
        this.setDELIVERY_UNIT(du);
        this.setVERSION(version);
        this.setVERSION_SP(sp);
        this.setVERSION_PATCH(patch);
        DUVersion duVersion = new DUVersion(version, sp, patch);
        this.setDuVersion(duVersion);
    }

    public DUVersion getDuVersion() {
        return this.duVersion;
    }

    public void setDuVersion(DUVersion duVersion) {
        this.duVersion = duVersion;
    }

    public String getDELIVERY_UNIT() {
        return this.DELIVERY_UNIT;
    }

    public void setDELIVERY_UNIT(String du) {
        this.DELIVERY_UNIT = du;
    }

    public String getVERSION() {
        return this.VERSION;
    }

    public void setVERSION(String version) {
        this.VERSION = version;
    }

    public String getVERSION_SP() {
        return this.VERSION_SP;
    }

    public void setVERSION_SP(String sp) {
        this.VERSION_SP = sp;
    }

    public String getVERSION_PATCH() {
        return this.VERSION_PATCH;
    }

    public void setVERSION_PATCH(String patch) {
        this.VERSION_PATCH = patch;
    }

    public String getPPMS_ID() {
        return this.PPMS_ID;
    }

    public void setPPMS_ID(String ppms) {
        this.PPMS_ID = ppms;
    }

    public String getCAPTION() {
        return this.CAPTION;
    }

    public void setCAPTION(String caption) {
        this.CAPTION = caption;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.DELIVERY_UNIT).append(" | ");
        sb.append(this.printVersion()).append(" | ");
        sb.append(this.PPMS_ID).append(" | ");
        sb.append(this.CAPTION);
        sb.append("Type: ").append(this.getType());
        return sb.toString();
    }

    public String printVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVERSION()).append(".");
        sb.append(this.getVERSION_SP()).append(".");
        sb.append(this.getVERSION_PATCH());
        return sb.toString();
    }

    public boolean sameName(DU another) {
        return this.getDELIVERY_UNIT().equalsIgnoreCase(another.getDELIVERY_UNIT());
    }

    public void grantHANA_UMMLRole(JdbcConnection connection, DatabaseSqlUserName sqlUserName) {
        if (null == sqlUserName) {
            return;
        }
        if (this.getDELIVERY_UNIT().equalsIgnoreCase(HANA_UMML)) {
            String callProcedure = "CALL _SYS_REPO.GRANT_ACTIVATED_ROLE('sap.hana.pai::ExecutePAI','" + sqlUserName.get() + "')";
            LogFactory.writeLogEntry(DU.class, "Run SQL command: " + callProcedure);
            try {
                CallableStatement cs = connection.getConnection().prepareCall("{" + callProcedure + "}");
                cs.execute();
            }
            catch (SQLException e) {
                LogFactory.writeLogEntry(DU.class, "Could not grant role vsap.hana.pai::ExecutePAI to " + sqlUserName.get());
            }
        }
    }
}

