/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.du;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.du.DU;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DUReaderDB {
    static String RELEASE = "release";
    static String REV_NUMBER = "rev-number";
    static String REV_PATCHLEVEL = "rev-patchlevel";

    public static List<DU> listDUs(JdbcConnection connection) {
        ArrayList<DU> dUnits = new ArrayList<DU>();
        String statement = "SELECT DELIVERY_UNIT, VERSION, VERSION_SP, VERSION_PATCH, PPMS_ID, CAPTION from _SYS_REPO.DELIVERY_UNITS";
        PreparedStatement prepStmt = connection.prepareSQLCommand(statement);
        ResultSet resultSet = null;
        try {
            resultSet = prepStmt.executeQuery();
            String du = "";
            String version = "";
            String sp = "";
            String patch = "";
            String ppms = "";
            String caption = "";
            while (resultSet.next()) {
                du = resultSet.getString(1);
                version = resultSet.getString(2);
                sp = resultSet.getString(3);
                patch = resultSet.getString(4);
                ppms = resultSet.getString(5);
                caption = resultSet.getString(6);
                DU dUnit = new DU(du, version, sp, patch, ppms, caption);
                dUnit.setType(DU.DU);
                dUnits.add(dUnit);
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(DUReaderDB.class, "Error during list DUs: " + statement + " message: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            IOUtils.closeQuietly(resultSet);
            IOUtils.closeQuietly(prepStmt);
        }
        return dUnits;
    }

    public static List<DU> listPlugins(JdbcConnection connection) {
        ArrayList<DU> dUnits = new ArrayList<DU>();
        String statement = "select PLUGIN_NAME, KEY, VALUE from SYS.M_PLUGIN_MANIFESTS where KEY = 'release' or key = 'rev-number' or key = 'rev-patchlevel' order by PLUGIN_NAME";
        PreparedStatement prepStmt = connection.prepareSQLCommand(statement);
        ResultSet resultSet = null;
        try {
            resultSet = prepStmt.executeQuery();
            String du = "";
            String version = "";
            String sp = "";
            String patch = "";
            String key = "";
            while (resultSet.next()) {
                du = resultSet.getString(1);
                key = resultSet.getString(2);
                if (key.equalsIgnoreCase(RELEASE)) {
                    version = resultSet.getString(3);
                } else if (key.equalsIgnoreCase(REV_NUMBER)) {
                    sp = resultSet.getString(3);
                } else if (key.equalsIgnoreCase(REV_PATCHLEVEL)) {
                    patch = resultSet.getString(3);
                }
                if (du.length() <= 0 || version.length() <= 0 || sp.length() <= 0 || patch.length() <= 0) continue;
                DU dUnit = new DU(du, version, sp, patch);
                dUnit.setType(DU.PLUGIN);
                dUnits.add(dUnit);
                du = "";
                version = "";
                sp = "";
                patch = "";
                key = "";
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(DUReaderDB.class, "Error during list DUs: " + statement + " message: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            IOUtils.closeQuietly(resultSet);
            IOUtils.closeQuietly(prepStmt);
        }
        return dUnits;
    }

    public static boolean pluginExists(JdbcConnection connection, String pluginName) {
        String statement = "select * from SYS.M_PLUGIN_STATUS where PLUGIN_NAME = ?";
        PreparedStatement prepStmt = connection.prepareSQLCommand(statement);
        ResultSet resultSet = null;
        boolean ret = false;
        try {
            prepStmt.setString(1, pluginName);
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                ret = true;
            }
        }
        catch (SQLException e) {
            try {
                LogFactory.writeLogEntry(DUReaderDB.class, "Error during list Plugins: " + statement + " message: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(prepStmt);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(prepStmt);
        return ret;
    }
}

