/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.du;

public class DUVersion {
    private double version = 0.0;
    private double version_sp = 0.0;
    private double version_patch = 0.0;

    public DUVersion(String version_string, String sp_string, String patch_string) {
        this.setVersion(version_string);
        this.setVersion_sp(sp_string);
        this.setVersion_patch(patch_string);
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(String version_string) {
        this.version = this.toDouble(version_string);
    }

    public double getVersion_sp() {
        return this.version_sp;
    }

    public void setVersion_sp(String sp_string) {
        this.version_sp = this.toDouble(sp_string);
    }

    public double getVersion_patch() {
        return this.version_patch;
    }

    public void setVersion_patch(String patch_string) {
        this.version_patch = this.toDouble(patch_string);
    }

    private double toDouble(String versionString) {
        double ver = 0.0;
        try {
            ver = Double.parseDouble(versionString);
        }
        catch (NumberFormatException e) {
            ver = 0.0;
        }
        return ver;
    }

    public boolean isVersionBiggerOrEqual(DUVersion another) {
        if (this.version > another.version) {
            return true;
        }
        if (this.version < another.version) {
            return false;
        }
        if (this.version_sp > another.version_sp) {
            return true;
        }
        if (this.version_sp < another.version_sp) {
            return false;
        }
        return this.version_patch >= another.version_patch;
    }
}

