/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.du;

import com.sap.hdb.sl.lib.du.DUInStack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StackXmlReader {
    private Document doc = null;
    private File stackDir = null;

    public StackXmlReader(String stack) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        File file = new File(stack);
        this.stackDir = file.getParentFile();
        if (!this.stackDir.exists()) {
            this.stackDir = null;
        }
        this.doc = builder.parse(file);
        this.doc.getDocumentElement().normalize();
    }

    public List<DUInStack> findDUs() {
        ArrayList<DUInStack> dUnits = new ArrayList<DUInStack>();
        String type = "";
        String name = "";
        String ppms = "";
        String version = "";
        String spLevel = "";
        String patchLevel = "";
        String os = "";
        String archName = "";
        NodeList softwareComponents = this.doc.getElementsByTagName("software-component");
        for (int i = 0; i < softwareComponents.getLength(); ++i) {
            Element scElement;
            Node sc = softwareComponents.item(i);
            if (sc.getNodeType() != 1 || !(type = (scElement = (Element)sc).getElementsByTagName("runtime-type").item(0).getTextContent()).equalsIgnoreCase("HDB")) continue;
            name = scElement.getElementsByTagName("name").item(0).getTextContent();
            ppms = scElement.getElementsByTagName("ppms-number").item(0).getTextContent();
            version = scElement.getElementsByTagName("version").item(0).getTextContent();
            NodeList sPackage = scElement.getElementsByTagName("support-package");
            for (int j = 0; j < sPackage.getLength(); ++j) {
                Node pack = sPackage.item(j);
                if (pack.getNodeType() != 1) continue;
                Element packElement = (Element)pack;
                spLevel = packElement.getElementsByTagName("sp-level").item(0).getTextContent();
                patchLevel = packElement.getElementsByTagName("patch-level").item(0).getTextContent();
                NodeList archives = packElement.getElementsByTagName("archives");
                for (int k = 0; k < archives.getLength(); ++k) {
                    Node arch = archives.item(j);
                    if (arch.getNodeType() != 1) continue;
                    Element archElement = (Element)arch;
                    Node osset = archElement.getElementsByTagName("os-set").item(0);
                    os = osset.getAttributes().getNamedItem("os").getNodeValue();
                    archName = archElement.getElementsByTagName("archive-name").item(0).getTextContent();
                }
            }
            DUInStack du = new DUInStack(name, version, spLevel, patchLevel, ppms, "");
            du.setArchName(archName);
            du.setOs(os);
            File archFile = new File(this.stackDir, archName);
            du.setArchFile(archFile);
            dUnits.add(du);
        }
        return dUnits;
    }
}

