/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.exceptions;

import com.sap.hdb.sl.lib.logging.LogFactory;

public class HdbException
extends RuntimeException {
    private static final long serialVersionUID = 8121407644335931930L;
    public static String LICENSE_EXPIRED = "LICENSE_EXPIRED";
    public static int INVALID_TABLE_NAME = 259;

    public HdbException() {
    }

    public HdbException(String arg0) {
        super(arg0);
    }

    public HdbException(Throwable arg0) {
        super(arg0);
    }

    public HdbException(String arg0, Throwable arg1) {
        super(arg0, arg1);
    }

    public boolean testDatabaseNotExists() {
        boolean test = false;
        String message = this.getMessage();
        if (message.contains("[2]") && message.contains("database") && (message.contains("does not exist") || message.contains("not connected"))) {
            test = true;
        }
        return test;
    }

    public boolean testConnectionRefused() {
        return this.getMessage().contains("-813");
    }

    public boolean testInvalidUsernameOrPassword() {
        return this.getMessage().contains("invalid username or password") || this.getMessage().contains("authentication failed");
    }

    public boolean testSQLNonTransientConnectionException() {
        boolean receiveFailed;
        boolean bl = receiveFailed = this.getMessage().contains("Data receive failed") || this.getMessage().contains("SQLNonTransientConnectionException");
        if (receiveFailed) {
            LogFactory.writeLogEntry(this.getClass(), this.getMessage() + " received. Try with multiple-container system.");
        }
        return receiveFailed;
    }

    public boolean testLicenseExpired() {
        return this.getMessage().contains("[437]") && this.getMessage().contains("only commands for license handling are allowed in current state");
    }

    public boolean testInvalidSystemId() {
        return this.getMessage().contains("System ID is not allowed") || this.getMessage().contains("System ID  has to be 3 characters long");
    }

    public boolean testInsufficientPrivilege() {
        return this.getMessage().contains("[258]") && this.getMessage().contains("insufficient privilege");
    }

    public boolean testConnectionReset() {
        return this.getMessage().contains("error 104");
    }
}

