/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.extension;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExtCmdClazzName {
    private Class<? extends CmdClazzNameIF> cmdClazzName = null;
    private Method valueOf = null;
    private Method values = null;

    public ExtCmdClazzName(String cmdClazzNameClass) {
        try {
            Class<?> tmpClazz = Class.forName(cmdClazzNameClass);
            Class<?>[] interfaces = tmpClazz.getInterfaces();
            boolean found = false;
            for (Class<?> interfaze : interfaces) {
                if (!interfaze.equals(CmdClazzNameIF.class)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new HdbException(cmdClazzNameClass + "; Extension does not implement Interface: " + CmdClazzNameIF.class.getName() + " !");
            }
            if (!tmpClazz.isEnum()) {
                throw new HdbException(cmdClazzNameClass + "; Clazz must be of type enum!");
            }
            this.cmdClazzName = tmpClazz;
            this.valueOf = this.cmdClazzName.getMethod("valueOf", String.class);
            this.values = this.cmdClazzName.getMethod("values", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new HdbException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HdbException(e);
        }
        catch (SecurityException e) {
            throw new HdbException(e);
        }
    }

    public boolean exists() {
        boolean hasInstance = false;
        if (null != this.cmdClazzName) {
            hasInstance = true;
        }
        return hasInstance;
    }

    public CmdClazzNameIF valueOf(String key) {
        try {
            return (CmdClazzNameIF)this.valueOf.invoke(this.cmdClazzName, key);
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e);
        }
        catch (InvocationTargetException e) {
            throw new HdbException(e);
        }
        catch (SecurityException e) {
            throw new HdbException(e);
        }
    }

    public CmdClazzNameIF[] values() {
        try {
            return (CmdClazzNameIF[])this.values.invoke(this.cmdClazzName, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e);
        }
        catch (InvocationTargetException e) {
            throw new HdbException(e);
        }
        catch (SecurityException e) {
            throw new HdbException(e);
        }
    }

    public boolean has(String key) {
        boolean has = false;
        for (CmdClazzNameIF clazzName : this.values()) {
            if (clazzName.toString().equals(key)) {
                // empty if block
            }
            has = true;
        }
        return has;
    }
}

