/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.extension;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExtCmdClazzParameterName {
    private Class<? extends CmdClazzParameterNameIF> cmdClazzParameterName = null;
    private Method valueOf = null;
    private Method values = null;

    public ExtCmdClazzParameterName(String cmdClazzParameterNameClass) {
        try {
            Class<?> tmpClazz = Class.forName(cmdClazzParameterNameClass);
            Class<?>[] interfaces = tmpClazz.getInterfaces();
            boolean found = false;
            for (Class<?> interfaze : interfaces) {
                if (!interfaze.equals(CmdClazzParameterNameIF.class)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new HdbException(cmdClazzParameterNameClass + "; Extension does not implement Interface: " + CmdClazzParameterNameIF.class.getName() + " !");
            }
            if (!tmpClazz.isEnum()) {
                throw new HdbException(cmdClazzParameterNameClass + "; Clazz must be of type enum!");
            }
            this.cmdClazzParameterName = tmpClazz;
            this.valueOf = this.cmdClazzParameterName.getMethod("valueOf", String.class);
            this.values = this.cmdClazzParameterName.getMethod("values", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new HdbException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HdbException(e);
        }
        catch (SecurityException e) {
            throw new HdbException(e);
        }
    }

    public boolean exists() {
        boolean hasInstance = false;
        if (null != this.cmdClazzParameterName) {
            hasInstance = true;
        }
        return hasInstance;
    }

    public CmdClazzParameterNameIF valueOf(String key) {
        try {
            return (CmdClazzParameterNameIF)this.valueOf.invoke(this.cmdClazzParameterName, key);
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e);
        }
        catch (InvocationTargetException e) {
            throw new HdbException(e);
        }
        catch (SecurityException e) {
            throw new HdbException(e);
        }
    }

    public CmdClazzParameterNameIF[] values() {
        try {
            return (CmdClazzParameterNameIF[])this.values.invoke(this.cmdClazzParameterName, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e);
        }
        catch (InvocationTargetException e) {
            throw new HdbException(e);
        }
        catch (SecurityException e) {
            throw new HdbException(e);
        }
    }

    public boolean has(String key) {
        boolean has = false;
        for (CmdClazzParameterNameIF parameterName : this.values()) {
            if (!parameterName.toString().equals(key)) continue;
            has = true;
        }
        return has;
    }
}

