/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.extension;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.extension.ExtCmdClazzName;
import com.sap.hdb.sl.lib.extension.ExtCmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExtensionFactory {
    private static Set<ExtCmdClazzParameterName> cmdClazzParameterNameClasses = new HashSet<ExtCmdClazzParameterName>();
    private static Set<ExtCmdClazzName> cmdClazzNameClasses = new HashSet<ExtCmdClazzName>();

    public static Set<ExtCmdClazzParameterName> getCmdClazzParameterNameClasses() {
        return cmdClazzParameterNameClasses;
    }

    public static Set<ExtCmdClazzName> getCmdClazzNameClasses() {
        return cmdClazzNameClasses;
    }

    private static Set<String> readJar(File file) throws IOException {
        HashSet<String> list = new HashSet<String>();
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String fqClassName;
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class") || !(fqClassName = jarEntry.getName().substring(0, jarEntry.getName().length() - 6).replaceAll("/", ".")).startsWith("com.sap.hdb.sl.lib.ext")) continue;
            list.add(fqClassName);
        }
        try {
            jar.close();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        return list;
    }

    private static Set<String> readDir(File dir, String packageName) throws IOException {
        HashSet<String> list = new HashSet<String>();
        if (!dir.isDirectory()) {
            return list;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(ExtensionFactory.readDir(file, packageName + (packageName.isEmpty() ? "" : ".") + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class") || !packageName.startsWith("com.sap.hdb.sl.lib.ext")) continue;
            list.add(packageName + (packageName.isEmpty() ? "" : ".") + file.getName().substring(0, file.getName().length() - 6));
        }
        return list;
    }

    public static void create() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlCl = (URLClassLoader)contextClassLoader;
        URL[] urls = urlCl.getURLs();
        HashSet<String> classes = new HashSet<String>();
        try {
            for (URL url : urls) {
                File file = new File(url.toURI());
                if (file.isDirectory()) {
                    classes.addAll(ExtensionFactory.readDir(file, ""));
                    continue;
                }
                if (!file.isFile()) continue;
                classes.addAll(ExtensionFactory.readJar(file));
            }
            for (String className : classes) {
                if (null == className) continue;
                Class<?> c = Class.forName(className);
                if (CmdClazzParameterNameIF.class.isAssignableFrom(c) && c.isEnum()) {
                    String cmdClazzParameterNameClass = c.getName();
                    cmdClazzParameterNameClasses.add(new ExtCmdClazzParameterName(cmdClazzParameterNameClass));
                    continue;
                }
                if (!CmdClazzNameIF.class.isAssignableFrom(c) || !c.isEnum()) continue;
                String cmdClazzNameClass = c.getName();
                cmdClazzNameClasses.add(new ExtCmdClazzName(cmdClazzNameClass));
            }
        }
        catch (Exception e) {
            throw new HdbException(e);
        }
    }
}

