/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdbmonitor;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdbmonitor.HDBMonitorParams;
import com.sap.hdb.sl.lib.hdbmonitor.UpgAnaXmlReader;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class HDBLoadHistoryMonitor {
    File outFile;
    File hdbmonctrl;
    long ctrlTimestamp = 0L;
    private JdbcConnection connection;
    private BufferedWriter bw;
    private UpgAnaXmlReader statReader;
    private File statFile;
    private File anaDir;
    private static String M_LOAD_HISTORY_HOST_SELECT = "SELECT HOST, TIME, CPU, ROUND(MEMORY_USED/1024/1024) AS MEMORY_USED_MB, ROUND(MEMORY_ALLOCATION_LIMIT/1024/1024) AS MEMORY_ALLOCATION_LIMIT_MB, ROUND(DISK_USED/1024/1024) AS DISK_USED_MB, ROUND(DISK_SIZE/1024/1024) AS DISK_SIZE_MB FROM M_LOAD_HISTORY_HOST WHERE TIME BETWEEN ? AND ? ORDER BY TIME ASC";
    private static String M_LOAD_HISTORY_HOST_COUNT = "SELECT COUNT(*) FROM M_LOAD_HISTORY_HOST WHERE TIME BETWEEN ? AND ? ";
    private static String UPGANAXML = "UPGANA.XML";
    ArrayList<String> phaseList = new ArrayList();
    ArrayList<String> memoryUsedList = new ArrayList();
    ArrayList<String> allocLimitList = new ArrayList();
    ArrayList<String> cpuList = new ArrayList();
    ArrayList<String> diskUsedList = new ArrayList();
    ArrayList<String> diskSizeList = new ArrayList();

    public HDBLoadHistoryMonitor(HDBMonitorParams params) {
        this.connection = params.getConnection();
        this.anaDir = params.getAnapath();
        this.outFile = params.getOutFile();
        this.statFile = new File(this.anaDir, UPGANAXML);
        try {
            this.statReader = new UpgAnaXmlReader(this.statFile);
        }
        catch (FileNotFoundException e) {
            throw new HdbException("Could not find file " + this.statFile + " ", e);
        }
    }

    public void monitor() {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.outFile, false));
            this.bw.append("#HOST:TIMESTAMP:USED_MEMORY:MAX_MEMORY:CPU:DISK_USED_MB:DISK_SIZE_MB:PHASE");
            this.bw.newLine();
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not write to file " + this.outFile);
        }
        Connection con = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String host = null;
        Timestamp time = null;
        try {
            Timestamp startTime = this.statReader.getStartTimestamp();
            Timestamp finishTime = this.statReader.getFinishTimestamp();
            con = this.connection.getConnection();
            prepStmt = con.prepareStatement(M_LOAD_HISTORY_HOST_COUNT);
            prepStmt.setTimestamp(1, startTime);
            prepStmt.setTimestamp(2, finishTime);
            rs = prepStmt.executeQuery();
            rs.next();
            int count = rs.getInt("count(*)");
            int nth = 1;
            if (count > 1000) {
                nth = count / 1000;
            }
            int row = 0;
            prepStmt = con.prepareStatement(M_LOAD_HISTORY_HOST_SELECT);
            prepStmt.setTimestamp(1, startTime);
            prepStmt.setTimestamp(2, finishTime);
            rs = prepStmt.executeQuery();
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + M_LOAD_HISTORY_HOST_SELECT + "  (" + startTime + ", " + finishTime + ")");
            while (rs.next()) {
                row = rs.getRow();
                if (row % nth != 0 && row != 1 && row != count) continue;
                host = rs.getString("HOST");
                time = rs.getTimestamp("TIME");
                String cpu = Long.toString(rs.getLong("CPU"));
                String memoryUsed = Long.toString(rs.getLong("MEMORY_USED_MB"));
                String allocLimit = Long.toString(rs.getLong("MEMORY_ALLOCATION_LIMIT_MB"));
                String diskUsed = Long.toString(rs.getLong("DISK_USED_MB"));
                String diskSize = Long.toString(rs.getLong("DISK_SIZE_MB"));
                UpgAnaXmlReader.UpgAnaPhase phase = this.statReader.findPhase(time);
                try {
                    this.bw.append(host).append(";");
                    this.bw.append(time.toString()).append(";");
                    this.bw.append(memoryUsed).append(";");
                    this.bw.append(allocLimit).append(";");
                    this.bw.append(cpu).append(";");
                    this.bw.append(diskUsed).append(";");
                    this.bw.append(diskSize).append(";");
                    this.bw.append(phase.getPhaseName());
                    this.phaseList.add(phase.getPhaseName());
                    this.memoryUsedList.add(memoryUsed);
                    this.allocLimitList.add(allocLimit);
                    this.cpuList.add(cpu);
                    this.diskUsedList.add(diskUsed);
                    this.diskSizeList.add(diskSize);
                    this.bw.newLine();
                }
                catch (IOException e) {
                    LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not write to file " + this.outFile);
                }
            }
            try {
                this.bw.flush();
                this.bw.close();
            }
            catch (IOException e) {
                LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not read / write files!");
            }
        }
        catch (SQLException e) {
            String message = "Error during execution of SQL command: " + M_LOAD_HISTORY_HOST_SELECT + " " + e.getMessage();
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), message);
            try {
                con.close();
            }
            catch (SQLException e1) {
                message = "Error during close of connection: " + e1.getMessage();
                throw new HdbException(message);
            }
            finally {
                this.connection = null;
            }
            throw new HdbException(message);
        }
    }

    private void createHtmlMemory() {
        String stringPhaseList = this.phaseList2String();
        try {
            List<String> lines = this.getLinesFromTemplate("/com/sap/hdb/sl/lib/hdbmonitor/PerformanceMonitor.html");
            File perfHtml = new File(this.anaDir, "PerformanceMonitor.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(perfHtml, false));
            for (String line : lines) {
                if (line.contains("$phases")) {
                    line = "var xValues = " + stringPhaseList + ";";
                }
                if (line.contains("$memoryUsedList")) {
                    line = "var memoryUsedValues = " + this.memoryUsedList.toString() + ";";
                }
                if (line.contains("$allocLimitList")) {
                    line = "var allocLimitValues = " + this.allocLimitList.toString() + ";";
                }
                writer.append(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not read / write files!");
            throw new HdbException(e.getMessage());
        }
    }

    private void createHtmlCPU() {
        String stringPhaseList = this.phaseList2String();
        try {
            List<String> lines = this.getLinesFromTemplate("/com/sap/hdb/sl/lib/hdbmonitor/PerformanceMonitorCPU.html");
            File perfHtml = new File(this.anaDir, "PerformanceMonitorCPU.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(perfHtml, false));
            for (String line : lines) {
                if (line.contains("$phases")) {
                    line = "var xValues = " + stringPhaseList + ";";
                }
                if (line.contains("$cpuList")) {
                    line = "var cpuValues = " + this.cpuList.toString() + ";";
                }
                writer.append(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not read / write files!");
            throw new HdbException(e.getMessage());
        }
    }

    private void createHtmlDisk() {
        String stringPhaseList = this.phaseList2String();
        try {
            List<String> lines = this.getLinesFromTemplate("/com/sap/hdb/sl/lib/hdbmonitor/PerformanceMonitorDisk.html");
            File perfHtml = new File(this.anaDir, "PerformanceMonitorDisk.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(perfHtml, false));
            for (String line : lines) {
                if (line.contains("$phases")) {
                    line = "var xValues = " + stringPhaseList + ";";
                }
                if (line.contains("$diskUsedList")) {
                    line = "var diskUsedList = " + this.diskUsedList.toString() + ";";
                }
                if (line.contains("$diskSizeList")) {
                    line = "var diskSizeList = " + this.diskSizeList.toString() + ";";
                }
                writer.append(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not read / write files!");
            throw new HdbException(e.getMessage());
        }
    }

    private List<String> getLinesFromTemplate(String resource) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(resource);
        ArrayList<String> lines = new ArrayList<String>();
        if (in != null) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
            in.close();
        }
        return lines;
    }

    private String phaseList2String() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String phase : this.phaseList) {
            sb.append("'").append(phase).append("'").append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

