/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdbmonitor;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdbmonitor.HDBMonitorParams;
import com.sap.hdb.sl.lib.hdbmonitor.SAPupLogReader;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;

public class HDBMonitorProcess
implements Runnable {
    File outFile;
    File hdbmonctrl;
    long ctrlTimestamp = 0L;
    String keeprunning = "";
    private JdbcConnection connection;
    private int millis;
    private BufferedWriter bw;
    private SAPupLogReader statReader;
    private File statFile;
    private File logDir;
    private static String USED_MEMORY = "SELECT ROUND(SUM(TOTAL_MEMORY_USED_SIZE)/1024/1024) AS TOTAL_USED FROM SYS.M_SERVICE_MEMORY";
    private static String MAX_MEMORY = "SELECT ROUND(MAX(EFFECTIVE_ALLOCATION_LIMIT)/1024/1024) FROM SYS.M_SERVICE_MEMORY";
    private static String SAPUP_LOG = "SAPup.log";

    public HDBMonitorProcess(HDBMonitorParams params) {
        this.connection = params.getConnection();
        this.keeprunning = params.getKeeprunning();
        this.logDir = params.getLogDir();
        this.outFile = params.getOutFile();
        this.statFile = new File(this.logDir, SAPUP_LOG);
        try {
            this.hdbmonctrl = new File(this.logDir, "hdbmonctrl");
            PrintWriter ctrlwrt = new PrintWriter(this.hdbmonctrl);
            ctrlwrt.println("keeprunning=" + this.keeprunning);
            ctrlwrt.flush();
            this.statReader = new SAPupLogReader(this.statFile);
        }
        catch (FileNotFoundException e) {
            throw new HdbException("Could not find file " + this.statFile + " ", e);
        }
        String sleep = params.getSleep();
        this.millis = Integer.valueOf(sleep) * 1000;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Error in Thread.sleep");
        }
        if (!this.keeprunning.equalsIgnoreCase("true")) {
            this.monitor();
        } else {
            while (true) {
                this.monitor();
                if (!this.shouldContinue()) break;
                try {
                    Thread.sleep(this.millis);
                }
                catch (InterruptedException e) {
                    LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Error in Thread.sleep");
                }
            }
        }
    }

    private void monitor() {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not write to file " + this.outFile);
        }
        String usedMemory = "";
        String maxMemory = "";
        List<String> result = this.connection.executeSQLCommand(USED_MEMORY);
        if (result.size() == 0) {
            throw new HdbException("No result for '" + USED_MEMORY + "'. ");
        }
        String longString = result.get(0);
        usedMemory = longString.substring(0, longString.indexOf("."));
        result = this.connection.executeSQLCommand(MAX_MEMORY);
        if (result.size() == 0) {
            throw new HdbException("No result for '" + MAX_MEMORY + "'. ");
        }
        longString = result.get(0);
        maxMemory = longString.substring(0, longString.indexOf("."));
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String tmString = dateFormat.format(timestamp);
        String phase = this.statReader.findPhase(timestamp);
        try {
            this.bw.append(tmString).append(";");
            this.bw.append(usedMemory).append(";");
            this.bw.append(maxMemory).append(";");
            this.bw.append(phase);
            this.bw.newLine();
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not write to file " + this.outFile);
        }
        try {
            this.bw.flush();
            this.bw.close();
        }
        catch (IOException e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not read / write files!");
        }
    }

    private boolean shouldContinue() {
        if (this.ctrlTimestamp != this.hdbmonctrl.lastModified()) {
            this.ctrlTimestamp = this.hdbmonctrl.lastModified();
            try {
                BufferedReader b = new BufferedReader(new FileReader(this.hdbmonctrl));
                String readLine = b.readLine();
                if (readLine != null && readLine.trim().contains("keeprunning") && !readLine.contains("false")) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
            return false;
        }
        return true;
    }
}

