/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdbmonitor;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

public class SAPupLogReader
extends RandomAccessFile {
    private File file;
    Timestamp startTS;
    Timestamp finishTS;
    String lastPhase = "";
    String pattern = "yyyyMMddHHmmss";
    TreeMap<String, String> phasesMap = new TreeMap();

    public SAPupLogReader(File file) throws FileNotFoundException {
        this(file, "r");
        this.file = file;
    }

    public SAPupLogReader(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.parsePhases();
    }

    public void parsePhases() {
        boolean finishFound = true;
        String currentPhase = null;
        String startTime = null;
        String finishTime = null;
        String line = null;
        boolean skipped = false;
        try {
            while ((line = this.readLine()) != null && finishFound) {
                if (!line.startsWith("CURRENTPHASE ")) continue;
                currentPhase = line.substring(13);
                currentPhase.trim();
                finishFound = false;
                if (currentPhase.length() > 0) {
                    while ((line = this.readLine()) != null && !finishFound) {
                        if (line.startsWith("...started at ")) {
                            startTime = line.substring(14);
                            startTime.trim();
                        }
                        if (!line.startsWith("...finished at ")) continue;
                        if (line.contains("SKIPPED")) {
                            finishFound = true;
                            skipped = true;
                            break;
                        }
                        finishTime = line.substring(15, 29);
                        finishTime.trim();
                        finishFound = true;
                        skipped = false;
                    }
                }
                if (skipped) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(currentPhase);
                this.phasesMap.put(startTime, sb.toString());
            }
        }
        catch (IOException e) {
            throw new HdbException("Could not read from file " + this.file, e);
        }
    }

    public String findPhase(Timestamp time) {
        String stringTime = this.getStringFromTimestamp(time, this.pattern);
        String key = this.phasesMap.floorKey(stringTime);
        return this.phasesMap.get(key);
    }

    public Timestamp getStartTimestamp() {
        String first = this.phasesMap.firstKey();
        return this.getTimestampFromString(first, this.pattern);
    }

    public Timestamp getFinishTimestamp() {
        String last = this.phasesMap.lastKey();
        return this.getTimestampFromString(last, this.pattern);
    }

    public Timestamp getTimestampFromString(String str, String pattern) {
        Date d;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            d = sdf.parse(str);
        }
        catch (ParseException e) {
            throw new HdbException("Could not parse " + str + " to Date", e);
        }
        Timestamp timestamp = new Timestamp(d.getTime());
        return timestamp;
    }

    public String getStringFromTimestamp(Timestamp time, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String tmString = sdf.format(time);
        return tmString;
    }
}

