/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdbmonitor;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpgAnaXmlReader
extends RandomAccessFile {
    private File file;
    Timestamp startTS;
    Timestamp finishTS;
    String lastPhase = "";
    String pattern = "yyyyMMddHHmmss";
    TreeMap<String, UpgAnaPhase> phasesMap = new TreeMap();
    private Document doc = null;

    public UpgAnaXmlReader(File file) throws FileNotFoundException {
        this(file, "r");
        this.file = file;
    }

    public UpgAnaXmlReader(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.file = file;
        this.parsePhases();
    }

    public void parsePhases() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        String phaseName = null;
        String startTime = null;
        String endtime = null;
        boolean skipped = false;
        boolean failed = false;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(this.file);
            this.doc.getDocumentElement().normalize();
            NodeList phaseNodes = this.doc.getElementsByTagName("phase");
            int l = phaseNodes.getLength();
            for (int i = 0; i < l; ++i) {
                Node phase = phaseNodes.item(i);
                NamedNodeMap attrs = phase.getAttributes();
                skipped = null != attrs.getNamedItem("skipped");
                boolean bl = failed = null != attrs.getNamedItem("failed");
                if (skipped || failed) continue;
                phaseName = attrs.getNamedItem("name").getNodeValue();
                startTime = attrs.getNamedItem("starttime").getNodeValue();
                endtime = attrs.getNamedItem("endtime").getNodeValue();
                UpgAnaPhase upgPhase = new UpgAnaPhase(phaseName, startTime, endtime);
                StringBuilder sb = new StringBuilder();
                sb.append(phaseName);
                this.putPhaseIntoMap(upgPhase);
            }
        }
        catch (IOException e) {
            throw new HdbException("Could not read from file " + this.file, e);
        }
        catch (ParserConfigurationException pe) {
            throw new HdbException("Could not parse file " + this.file, pe);
        }
        catch (SAXException se) {
            throw new HdbException("Could not sax file " + this.file, se);
        }
    }

    private void putPhaseIntoMap(UpgAnaPhase phase) {
        String startTime = phase.getStartTime();
        UpgAnaPhase existingPhase = this.phasesMap.get(startTime);
        if (null == existingPhase) {
            this.phasesMap.put(startTime, phase);
        } else {
            Timestamp phaseEndTime;
            Timestamp existingEndTime = this.getTimestampFromString(existingPhase.getEndtime(), this.pattern);
            if (existingEndTime.before(phaseEndTime = this.getTimestampFromString(phase.getEndtime(), this.pattern))) {
                this.phasesMap.put(startTime, phase);
            }
        }
    }

    public UpgAnaPhase findPhase(Timestamp time) {
        String stringTime = this.getStringFromTimestamp(time, this.pattern);
        String key = this.phasesMap.floorKey(stringTime);
        return this.phasesMap.get(key);
    }

    public Timestamp getStartTimestamp() {
        String first = this.phasesMap.firstKey();
        return this.getTimestampFromString(first, this.pattern);
    }

    public Timestamp getFinishTimestamp() {
        String last = this.phasesMap.lastKey();
        UpgAnaPhase lastAnaPhase = this.phasesMap.get(last);
        return this.getTimestampFromString(lastAnaPhase.getEndtime(), this.pattern);
    }

    public Timestamp getTimestampFromString(String str, String pattern) {
        Date d;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            d = sdf.parse(str);
        }
        catch (ParseException e) {
            throw new HdbException("Could not parse " + str + " to Date", e);
        }
        Timestamp timestamp = new Timestamp(d.getTime());
        return timestamp;
    }

    public String getStringFromTimestamp(Timestamp time, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String tmString = sdf.format(time);
        return tmString;
    }

    class UpgAnaPhase {
        String phaseName;
        String startTime;
        String endtime;

        UpgAnaPhase(String phaseName, String startTime, String endtime) {
            this.phaseName = phaseName;
            this.startTime = startTime;
            this.endtime = endtime;
        }

        public String getPhaseName() {
            return this.phaseName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getEndtime() {
            return this.endtime;
        }
    }
}

