/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdi;

import com.sap.hdb.sl.lib.connection.sql.SQLFileWriter;
import com.sap.hdb.sl.lib.hdi.HdiData;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class GrantHDIPrivilegesShadowSQLs {
    static String newLine = System.getProperty("line.separator");
    static String prepareForDataApiContainer = "DROP TABLE #PRIVILEGES;" + newLine + "CREATE LOCAL TEMPORARY COLUMN TABLE #PRIVILEGES LIKE _SYS_DI.TT_API_PRIVILEGES;" + newLine + "INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) SELECT '<SHADOW-SCHEMA-NAME>', PRIVILEGE_NAME, OBJECT_NAME FROM _SYS_DI.T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES;" + newLine + "CALL _SYS_DI#<CONTAINER-GROUP-NAME>.GRANT_CONTAINER_GROUP_API_PRIVILEGES( #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ? );" + newLine + "TRUNCATE TABLE #PRIVILEGES;" + newLine + "INSERT INTO #PRIVILEGES ( PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME ) SELECT '<SHADOW-SCHEMA-NAME>', PRIVILEGE_NAME, OBJECT_NAME FROM _SYS_DI.T_DEFAULT_CONTAINER_USER_PRIVILEGES;";
    static String sqlForDataApiContainer = "CALL _SYS_DI#<CONTAINER-GROUP-NAME>.GRANT_CONTAINER_API_PRIVILEGES(  '<PHYSICAL-CONTAINER-NAME>', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ? );";
    static String drop = "DROP TABLE #PRIVILEGES;";

    public static void prepareSQL(HdiData data) throws IOException {
        LinkedList<String> sqlLines = new LinkedList<String>();
        String temp = "";
        sqlLines.add(prepareForDataApiContainer);
        LinkedList<String> dataContainers = data.getHdiContainersData();
        for (String container : dataContainers) {
            temp = sqlForDataApiContainer;
            temp = temp.replace("<PHYSICAL-CONTAINER-NAME>", container);
            sqlLines.add(temp);
        }
        LinkedList<String> apiContainers = data.getHdiContainersApi();
        for (String container : apiContainers) {
            temp = sqlForDataApiContainer;
            temp = temp.replaceAll("<PHYSICAL-CONTAINER-NAME>", container);
            sqlLines.add(temp);
        }
        sqlLines.add(drop);
        LinkedList<String> sqlLinesToExecute = new LinkedList<String>();
        for (String line : sqlLines) {
            line = line.replaceAll("<SHADOW-SCHEMA-NAME>", data.getShadowUserName());
            line = line.replaceAll("<CONTAINER-GROUP-NAME>", data.getContainerGroupName());
            sqlLinesToExecute.add(line);
        }
        GrantHDIPrivilegesShadowSQLs.writeToFile(sqlLinesToExecute, data.getSqlFile());
    }

    private static void writeToFile(LinkedList<String> sqlLines, File sqlFile) throws IOException {
        SQLFileWriter writer = new SQLFileWriter(sqlFile);
        writer.append(sqlLines.toArray(new String[0]));
        writer.flush();
    }
}

