/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdi;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.HDICreateContainerGroupAddPrivilegesSQLs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HDIHelper {
    static String CTS_AMHC_MAP = "CTS_AMHC_MAP";
    static String CTS_HOT_CONFIG = "CTS_HOT_CONFIG";

    public static String checkCVERSBasis(JdbcConnection connection, DatabaseSqlUser databaseUser) {
        String release = "UNKNOWN";
        connection.setConnectUser(databaseUser);
        if (HDIHelper.tableExists(connection, "CVERS")) {
            List<String> result = connection.executeSQLCommand("SELECT RELEASE FROM CVERS WHERE COMPONENT = 'SAP_BASIS'");
            if (result.size() > 0) {
                release = result.get(0);
            }
            LogFactory.writeLogEntry(HDIHelper.class, "Found SAP_BASIS release from CVERS " + release);
        }
        return release;
    }

    public static boolean tableExists(JdbcConnection connection, String tableName) {
        List<String> result = connection.executeSQLCommand("SELECT COUNT(*) FROM TABLES WHERE TABLE_NAME = '" + tableName + "' AND SCHEMA_NAME = CURRENT_USER");
        return result.get(0).equals("1");
    }

    public static boolean sapBasisNeedsHdi(String versionStr) {
        int version = 0;
        try {
            version = Integer.parseInt(versionStr);
        }
        catch (NumberFormatException e) {
            LogFactory.writeLogEntry(HDIHelper.class, "Could not parse SAP_BASIS release to int, read from CVERS " + versionStr);
            return false;
        }
        return HDIHelper.sapBasisNeedsHdi(version);
    }

    public static boolean sapBasisNeedsHdi(int version) {
        return version >= 752 && version <= 759 || version >= 769;
    }

    public static String getContainerGroupName(JdbcConnection connection, CmdClazzParameterMap parameters) {
        String containerName = null;
        if (HDIHelper.tableExists(connection, CTS_HOT_CONFIG)) {
            containerName = HDIHelper.findContainerGroupNameFromHtaTable(connection);
        }
        if (null == containerName) {
            File infoFile = HDIHelper.getContainerInfoFile(parameters);
            containerName = HDIHelper.getContainerGroupFromContainerInfoFile(infoFile);
        }
        return containerName;
    }

    public static String getContainerGroupFromContainerInfoFile(File containerInfoFile) {
        List<String> containers = HDIHelper.readContainerInfoFile(containerInfoFile);
        for (String string : containers) {
            if (!string.startsWith("HDI_CONTAINER_GROUP")) continue;
            return string.substring(string.indexOf("=") + 1);
        }
        return null;
    }

    public static String findContainerGroupNameFromHtaTable(JdbcConnection connection) {
        String containerName = null;
        if (HDIHelper.tableExists(connection, CTS_HOT_CONFIG)) {
            containerName = HDIHelper.getContainerFromHtaTable(connection);
        }
        return containerName;
    }

    public static List<String> getHdiContainers(JdbcConnection connection, CmdClazzParameterMap parameters) {
        List<Object> containers = new ArrayList();
        if (HDIHelper.tableExists(connection, CTS_AMHC_MAP)) {
            containers = HDIHelper.readContainersFromHTA(connection);
        }
        if (containers.size() == 0) {
            File infoFile = HDIHelper.getContainerInfoFile(parameters);
            containers = HDIHelper.getContainersFromContainerInfoFile(infoFile);
        }
        return containers;
    }

    public static File getContainerInfoFile(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.HDI_CONTAINER_INFO_FILE)) {
            String infoPath = parameters.get(CmdClazzParameterName.HDI_CONTAINER_INFO_FILE).getValue();
            return new File(infoPath);
        }
        return new File("./HdiContainers");
    }

    public static List<String> getContainersFromContainerInfoFile(File containerInfoFile) {
        List<String> lines = HDIHelper.readContainerInfoFile(containerInfoFile);
        ArrayList<String> containers = new ArrayList<String>();
        for (String string : lines) {
            if (string.startsWith("HDI_CONTAINER_GROUP")) continue;
            containers.add(string);
        }
        return containers;
    }

    private static List<String> readContainerInfoFile(File containerInfoFile) {
        ArrayList<String> containers = new ArrayList<String>();
        try {
            BufferedReader reader = HDIHelper.createReader(containerInfoFile);
            if (null != reader) {
                String l;
                while ((l = reader.readLine()) != null) {
                    l.trim();
                    if (l.length() <= 0) continue;
                    containers.add(l);
                }
            } else {
                LogFactory.writeLogEntry(HDIHelper.class, "No reader for container info file found. Nothing to do.");
            }
            reader.close();
        }
        catch (Exception e) {
            throw new HdbException(e.getMessage());
        }
        return containers;
    }

    private static BufferedReader createReader(File file) {
        if (!file.exists() || !file.isFile()) {
            LogFactory.writeLogEntry(HDIHelper.class, "File" + file + " not found. Nothing to do.");
            throw new HdbException("File " + file + " not found. Better stop");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        return br;
    }

    public static List<String> readContainersFromHTA(JdbcConnection connection) {
        ArrayList<String> containers = new ArrayList<String>();
        String sqlSelect = "SELECT PHYSICAL_CONTAINER_NAME FROM " + CTS_AMHC_MAP;
        String sqlExists = "select COUNT(*) from SYS.TABLES where TABLE_NAME = '" + CTS_AMHC_MAP + "' and SCHEMA_NAME = CURRENT_SCHEMA";
        List<String> result = connection.executeSQLCommand(sqlExists);
        if (!result.get(0).equals("1")) {
            LogFactory.writeLogEntry(HDIHelper.class, "Table " + CTS_AMHC_MAP + " doesn't exist.");
        } else {
            result = connection.executeSQLCommand(sqlSelect);
            for (String container : result) {
                containers.add(container);
            }
        }
        return containers;
    }

    private static String getContainerFromHtaTable(JdbcConnection connection) {
        List<String> result = connection.executeSQLCommand("SELECT VALUE from " + CTS_HOT_CONFIG + " WHERE NAME = 'HDI_CONTAINER_GROUP'");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public static int grantPrivileges(JdbcConnection connection, String containerGroupName, DatabaseSqlUser databaseUser) {
        int rc = HDIHelper.grantPrivilegesNew(connection, containerGroupName, databaseUser);
        if (1 == rc) {
            rc = HDIHelper.grantPrivilegesOld(connection, containerGroupName, databaseUser);
        }
        return rc;
    }

    private static int grantPrivilegesNew(JdbcConnection connection, String containerGroupName, DatabaseSqlUser databaseUser) {
        int rc;
        try {
            connection.executeSQLCommand("CREATE LOCAL TEMPORARY TABLE #PRIVILEGES LIKE _SYS_DI.TT_API_PRIVILEGES");
            connection.executeSQLCommand("INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) SELECT '" + databaseUser.getName().get() + "', PRIVILEGE_NAME, OBJECT_NAME FROM _SYS_DI.T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES");
            String callProcedure = "CALL _SYS_DI.GRANT_CONTAINER_GROUP_API_PRIVILEGES('" + containerGroupName + "', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
            LogFactory.writeLogEntry(HDIHelper.class, "Run SQL command: " + callProcedure);
            CallableStatement cs = connection.getConnection().prepareCall("{" + callProcedure + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            rc = cs.getInt(1);
            ResultSet resultSet = cs.getResultSet();
            boolean readMessages = true;
            LogFactory.writeLogEntry(HDIHelper.class, "Start Result Messages from CALL _SYS_DI.GRANT_CONTAINER_GROUP_API_PRIVILEGES ...");
            while (resultSet.next() && readMessages) {
                try {
                    String message = resultSet.getString("MESSAGE");
                    LogFactory.writeLogEntry(HDIHelper.class, message);
                }
                catch (Exception e) {
                    LogFactory.writeLogEntry(HDIHelper.class, "Could not read coulmn MESSAGE from the ResultSet. Skip reading it.");
                    readMessages = false;
                }
            }
            LogFactory.writeLogEntry(HDIHelper.class, "End Result Messages from CALL _SYS_DI.GRANT_CONTAINER_GROUP_API_PRIVILEGES ...");
        }
        catch (HdbException e) {
            String message = e.getMessage();
            if (message.contains("invalid table name") && message.contains("T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES")) {
                LogFactory.writeLogEntry(HDIHelper.class, "Could not grant privileges via T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES, fallback to the old way");
                return 1;
            }
            throw e;
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        return rc;
    }

    private static int grantPrivilegesOld(JdbcConnection connection, String containerGroupName, DatabaseSqlUser databaseUser) {
        int rc;
        LinkedList<String> sqls = HDICreateContainerGroupAddPrivilegesSQLs.getSqlList();
        for (String sql : sqls) {
            sql = sql.replace("<SAPSID>", databaseUser.getName().get());
            connection.executeSQLCommand(sql);
        }
        String sql = HDICreateContainerGroupAddPrivilegesSQLs.GRANT_PRIVILEGES_SQL_GRANT_CONTAINER_GROUP_API_PRIVILEGES;
        sql = sql.replace("<group name>", containerGroupName);
        try {
            CallableStatement cs = connection.getConnection().prepareCall("{" + sql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            rc = cs.getInt(1);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        return rc;
    }
}

