/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.hdi;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HdiData {
    String containerGroupName;
    String shadowUserName;
    File containerInfoFile;
    File sqlFile = null;
    LinkedList<String> hdiContainersApi;
    LinkedList<String> hdiContainersData;

    public HdiData(CmdClazzParameterMap parameters) {
        this.containerInfoFile = this.setContainerInfoFile(parameters);
        try {
            this.getContainerInfo();
        }
        catch (Exception e) {
            LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Error during reading from file " + this.containerInfoFile);
            throw new HdbException(e.getMessage());
        }
    }

    public File setContainerInfoFile(CmdClazzParameterMap parameters) {
        String infoPath = parameters.get(CmdClazzParameterName.HDI_CONTAINER_INFO_FILE).getValue();
        this.containerInfoFile = new File(infoPath);
        return new File(infoPath);
    }

    public void getContainerInfo() throws ParserConfigurationException, SAXException, IOException {
        this.hdiContainersApi = new LinkedList();
        this.hdiContainersData = new LinkedList();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(this.containerInfoFile);
        doc.getDocumentElement().normalize();
        Node HDIContainersForABAP = null;
        NodeList HDIContainerInfoList = doc.getElementsByTagName("HDIContainerInfo");
        Node HDIContainerInfoNode = HDIContainerInfoList.item(0);
        if (HDIContainerInfoNode.getNodeType() == 1) {
            NodeList HDIContainerInfoChildNodes = HDIContainerInfoNode.getChildNodes();
            for (int i = 0; i < HDIContainerInfoChildNodes.getLength(); ++i) {
                Node child = HDIContainerInfoChildNodes.item(i);
                if (child.getNodeType() == 1 && child.getNodeName() == "HDIContainerGroupNameForABAP") {
                    this.containerGroupName = child.getTextContent();
                }
                if (child.getNodeType() != 1 || child.getNodeName() != "HDIContainersForABAP") continue;
                HDIContainersForABAP = child;
            }
        }
        this.iterateOverHDIContainersForABAP(HDIContainersForABAP);
    }

    private void iterateOverHDIContainersForABAP(Node hdiContainersForABAP) {
        NodeList children = hdiContainersForABAP.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || child.getNodeName() != "HDIContainerForABAP") continue;
            this.iterateOverHDIContainer(child);
        }
    }

    private void iterateOverHDIContainer(Node hdiContainerNode) {
        String hdiContainerType = null;
        String hdiContainerName = null;
        NodeList children = hdiContainerNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName() == "HDIContainerType") {
                hdiContainerType = child.getTextContent();
            }
            if (child.getNodeType() != 1 || child.getNodeName() != "HDIContainerName_Physical") continue;
            hdiContainerName = child.getTextContent();
        }
        if (null != hdiContainerType && null != hdiContainerName) {
            if (hdiContainerType.equalsIgnoreCase("A")) {
                this.hdiContainersApi.add(hdiContainerName);
            } else if (hdiContainerType.equalsIgnoreCase("D")) {
                this.hdiContainersData.add(hdiContainerName);
            }
        }
    }

    public String getContainerGroupName() {
        return this.containerGroupName;
    }

    public LinkedList<String> getHdiContainersApi() {
        return this.hdiContainersApi;
    }

    public LinkedList<String> getHdiContainersData() {
        return this.hdiContainersData;
    }

    public String getShadowUserName() {
        return this.shadowUserName;
    }

    public void setShadowUserName(String shadowUserName) {
        this.shadowUserName = shadowUserName;
    }

    public File getContainerInfoFile() {
        return this.containerInfoFile;
    }

    public File getSqlFile() {
        if (null == this.sqlFile) {
            this.sqlFile = new File(this.getContainerInfoFile().getParentFile(), "HdiShadowGrants.sql");
        }
        return this.sqlFile;
    }
}

