/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseService;
import com.sap.hdb.sl.lib.instance.DatabaseStatisticsServer;
import com.sap.hdb.sl.lib.instance.DatabaseTimeZone;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.Port;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.instance.TenantSid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.security.JavaKeystore;
import com.sap.hdb.sl.lib.security.Sapgenpse;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class Database
extends Instance {
    private Sid sid = null;
    private String port = null;
    private String systemDBPort = null;
    private DatabaseMode databaseMode = DatabaseMode.SINGLE;
    private boolean isDatabaseModeSet = false;
    private boolean encrypt = false;
    private boolean certificateValidation = false;
    private String encryptPropertiesString = new String("encrypt=true&validateCertificate=false");
    private Properties properties = new Properties();
    private boolean forceEncrypt = false;

    protected Database(InstanceNumber number) {
        super(Instance.Type.HDB, number);
        this.sid = new Sid("");
    }

    protected Database(Port port) {
        super(Instance.Type.HDB);
        this.port = port.get();
        this.sid = new Sid("");
    }

    protected Database(InstanceNumber instanceNumber, Hostname host) {
        super(Instance.Type.HDB, instanceNumber, host);
        this.sid = new Sid("");
    }

    protected Database(InstanceNumber instanceNumber, HdbVersion version, Hostname host) {
        super(Instance.Type.HDB, instanceNumber, version, host);
        this.sid = new Sid("");
    }

    public void setSid(Sid sid) {
        this.sid = sid;
    }

    public Sid getSid() {
        return this.sid;
    }

    public Sid getSid(JdbcConnection connection, DatabaseUser sqlUser) {
        Sid dbSid = null;
        String statement = "SELECT DATABASE_NAME FROM M_DATABASE";
        List<String> result = this.executeStatement(statement, connection, sqlUser);
        if (result.size() != 1) {
            throw new HdbException(result + " Wrong result count for SQL query: " + statement);
        }
        dbSid = new Sid(result.get(0));
        return dbSid;
    }

    public String getSystem_id(JdbcConnection connection, DatabaseUser sqlUser) {
        String sysid = null;
        String statement = "SELECT SYSTEM_ID FROM M_DATABASE";
        List<String> result = this.executeStatement(statement, connection, sqlUser);
        if (result.size() != 1) {
            throw new HdbException(result + " Wrong result count for SQL query: " + statement);
        }
        sysid = result.get(0);
        return sysid;
    }

    public boolean isIndexServerOnline(JdbcConnection connection, DatabaseUser sqlUser) {
        boolean isOnline = false;
        DatabaseService databaseService = new DatabaseService(Instance.ServiceName.INDEXSERVER, connection, sqlUser);
        String status = databaseService.getStatus();
        LogFactory.writeLogEntry(this.getClass(), "Status of Indexserver is: " + status);
        if (status.equalsIgnoreCase("YES")) {
            isOnline = true;
        }
        return isOnline;
    }

    public String getPathForUsageType(JdbcConnection connection, DatabaseUser sqlUser, UsageType usage_type) {
        String path = null;
        String statement = "SELECT PATH FROM M_DISKS where usage_type = '" + (Object)((Object)usage_type) + "' and HOST = (SELECT HOST FROM SYS.M_DATABASE)";
        List<String> result = this.executeStatement(statement, connection, sqlUser);
        if (result.size() != 1) {
            throw new HdbException(result + " Wrong result count for SQL query: " + statement);
        }
        path = result.get(0);
        return path;
    }

    public String getTraceLocation(JdbcConnection connection, DatabaseUser sqlUser) {
        return this.getPathForUsageType(connection, sqlUser, UsageType.TRACE);
    }

    public boolean isStatisticsServerOnline(JdbcConnection connection, DatabaseUser connectUser) {
        if (!(connectUser instanceof DatabaseSystemUser)) {
            throw new HdbException(connectUser.getName().get() + ", User has to be the system user!");
        }
        DatabaseStatisticsServer statServer = new DatabaseStatisticsServer();
        return statServer.isOn(connection, (DatabaseSystemUser)connectUser);
    }

    public boolean isScaleOut(JdbcConnection connection, DatabaseUser sqlUser) {
        List<String> nodeList = this.getAllHosts(connection, sqlUser);
        if (nodeList.size() > 1) {
            LogFactory.writeLogEntry(this.getClass(), "Database is Scale Out System.");
            return true;
        }
        LogFactory.writeLogEntry(this.getClass(), "Database is not a Scale Out System.");
        return false;
    }

    public List<String> getAllHostsWithConfigRoleMaster(JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setConnectUser(sqlUser);
        List<String> nodeList = connection.executeSQLCommand("SELECT HOST FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE NAMESERVER_CONFIG_ROLE like 'MASTER%' ORDER BY NAMESERVER_ACTUAL_ROLE, NAMESERVER_CONFIG_ROLE");
        return nodeList;
    }

    public List<String> getAllHosts(JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setConnectUser(sqlUser);
        List<String> nodeList = connection.executeSQLCommand("SELECT HOST FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE HOST_STATUS IN ('OK','WARNING','INFO')");
        return nodeList;
    }

    public String getMasterHost(JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setConnectUser(sqlUser);
        List<String> nodeList = connection.executeSQLCommand("SELECT HOST FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE HOST_STATUS IN ('OK','WARNING','INFO') AND INDEXSERVER_ACTUAL_ROLE IN ('MASTER', 'COORDINATOR')");
        if (nodeList.size() == 0) {
            throw new HdbException("No SAP HANA master host was found. Please check your database configuration.");
        }
        if (nodeList.size() == 1) {
            return nodeList.get(0);
        }
        throw new HdbException(nodeList.size() + " SAP HANA master hosts were found. Please check your database configuration.");
    }

    public DatabaseTimeZone getTimeZoneForHost(JdbcConnection connection, DatabaseUser sqlUser, String hostname) {
        connection.setConnectUser(sqlUser);
        DatabaseTimeZone tz = new DatabaseTimeZone();
        PreparedStatement statement = connection.prepareSQLCommand("SELECT VALUE FROM M_HOST_INFORMATION WHERE KEY='timezone_offset' AND HOST=?");
        try {
            statement.setString(1, hostname);
        }
        catch (SQLException e) {
            throw new HdbException(e.getMessage(), e);
        }
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            LogFactory.writeLogEntry(this.getClass(), "No time zone offset was found for host " + hostname);
        } else if (result.size() == 1) {
            String offsetString = result.get(0);
            try {
                int offset = Integer.parseInt(offsetString);
                tz.setOffset(offset);
            }
            catch (NumberFormatException e) {
                LogFactory.writeLogEntry(this.getClass(), "Time zone offset " + offsetString + " is not a valid number: " + e.getMessage());
            }
        } else {
            throw new HdbException(result.size() + " time zone offsets were found for host " + hostname + ". Please check your database configration.");
        }
        statement = connection.prepareSQLCommand("SELECT VALUE FROM M_HOST_INFORMATION WHERE KEY='timezone_name' AND HOST=?");
        try {
            statement.setString(1, hostname);
        }
        catch (SQLException e) {
            throw new HdbException(e.getMessage(), e);
        }
        result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            LogFactory.writeLogEntry(this.getClass(), "No time zone offset was found for host " + hostname);
        } else if (result.size() == 1) {
            String name = result.get(0);
            tz.setName(name);
        } else {
            throw new HdbException(result.size() + " time zone offsets were found for host " + hostname + ". Please check your database configration.");
        }
        return tz;
    }

    public Map<String, DatabaseTimeZone> getTimeZonesForAllHosts(JdbcConnection connection, DatabaseUser sqlUser) {
        HashMap<String, DatabaseTimeZone> timeZoneMap = new HashMap<String, DatabaseTimeZone>();
        List<String> allHosts = this.getAllHosts(connection, sqlUser);
        for (String host : allHosts) {
            DatabaseTimeZone timeZoneForHost = this.getTimeZoneForHost(connection, sqlUser, host);
            timeZoneMap.put(host, timeZoneForHost);
        }
        return timeZoneMap;
    }

    public String getPublicNameForHost(JdbcConnection connection, DatabaseUser sqlUser, String host) {
        connection.setConnectUser(sqlUser);
        String key = "net_publicname";
        List<String> publicNameList = connection.executeSQLCommand("SELECT VALUE FROM \"PUBLIC\".\"M_HOST_INFORMATION\" WHERE HOST='" + host + "' AND KEY='" + key + "'");
        if (publicNameList.size() == 0) {
            LogFactory.writeLogEntry(this.getClass(), "No public name was found for host '" + host + "'. Using internal name.");
            return host;
        }
        if (publicNameList.size() == 1) {
            InetAddress address;
            String publicName = publicNameList.get(0);
            LogFactory.writeLogEntry(this.getClass(), "Resolving public name: " + publicName);
            try {
                address = InetAddress.getByName(publicName);
            }
            catch (UnknownHostException e) {
                String message = "An error occurred while resolving host " + publicName + ": " + e.getMessage();
                LogFactory.writeLogEntry(this.getClass(), message);
                throw new HdbException(message, e);
            }
            String hostName = address.getHostName();
            LogFactory.writeLogEntry(this.getClass(), "Found host name '" + hostName + "' for host '" + host + "'");
            return hostName;
        }
        String message = publicNameList.size() + " entries were found for host '" + host + "' and key '" + key + "', expected was 1. Please check your database configuration.";
        LogFactory.writeLogEntry(this.getClass(), message);
        throw new HdbException(message);
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setConnectUser(sqlUser);
        return connection.executeSQLCommand(statement);
    }

    public List<DatabaseUser> getDatabaseUsers(JdbcConnection connection, DatabaseUser connectUser) {
        ArrayList<DatabaseUser> users = new ArrayList<DatabaseUser>();
        connection.setConnectUser(connectUser);
        PreparedStatement statement = connection.prepareSQLCommand("SELECT USER_NAME FROM SYS.USERS");
        try {
            statement.execute();
            ResultSet result = statement.getResultSet();
            while (result.next()) {
                String userName = result.getString(1);
                if (!(userName.startsWith("_SYS_") || userName.equals("SYS") || userName.equals("SYSTEM"))) {
                    users.add(DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName(userName)));
                    continue;
                }
                if (!userName.equals("SYSTEM")) continue;
                users.add(DatabaseSystemUserFactory.getUser());
            }
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        return users;
    }

    public boolean isMultiDB(JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setConnectUser(sqlUser);
        DatabaseConfiguration globalConfig = new DatabaseConfiguration(connection, sqlUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection multiDbSection = globalConfig.getSection("multidb");
        String mode = multiDbSection.getParameterValue("mode");
        return "multidb".equals(mode);
    }

    public DatabaseMode getDatabaseMode(JdbcConnection connection, DatabaseUser connectUser) {
        connection.setConnectUser(connectUser);
        return connection.getDatabaseMode();
    }

    public boolean equals(Object theirDatabase) {
        if (!(theirDatabase instanceof Database)) {
            return false;
        }
        Hostname theirHostname = ((Database)theirDatabase).getHostname();
        InstanceNumber theirInstanceNumber = ((Database)theirDatabase).getNumber();
        Sid theirSid = ((Database)theirDatabase).getSid();
        return (this.getHostname() == null ? theirHostname == null : this.getHostname().equals(theirHostname)) && (this.getSid() == null ? theirSid == null : this.getSid().equals(theirSid)) && (this.getNumber() == null ? theirInstanceNumber == null : this.getNumber().equals(theirInstanceNumber));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result += 31 * result + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        result += 31 * result + (this.getSid() == null ? 0 : this.getSid().hashCode());
        result += 31 * result + (this.getNumber() == null ? 0 : this.getNumber().hashCode());
        return result;
    }

    public boolean isSystemDB() {
        return this.sid.isSystemDB();
    }

    public DatabaseMode getDatabaseMode() {
        return this.databaseMode;
    }

    public void setDatabaseMode(DatabaseMode databaseMode) {
        this.sid = DatabaseMode.SINGLE == databaseMode ? new Sid(this.sid.toString(), true) : new TenantSid(this.sid.toString());
        this.databaseMode = databaseMode;
        this.isDatabaseModeSet = true;
    }

    public boolean isDatabaseModeSet() {
        return this.isDatabaseModeSet;
    }

    public String getPort() {
        return this.port;
    }

    public Object getSqlPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSystemDBPort() {
        return this.systemDBPort;
    }

    public void setSystemDBPort(String systemDBPort) {
        this.systemDBPort = systemDBPort;
    }

    public boolean isEncryptTrue() {
        return this.encrypt;
    }

    public boolean setEncrypt(String ssl) {
        this.encrypt = ssl.equalsIgnoreCase("true") || ssl.equalsIgnoreCase("1") || ssl.equalsIgnoreCase("yes");
        return this.encrypt;
    }

    public Properties getEncrytionProperties() {
        if (this.encryptPropertiesString.indexOf(",") == -1) {
            Properties encryptProps = new Properties();
            try {
                encryptProps.load(new StringReader(this.encryptPropertiesString.replace('&', '\n')));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return encryptProps;
        }
        this.setJDBCProperties(this.encryptPropertiesString);
        return this.properties;
    }

    public Properties getDefaultEncrytionProperties() {
        Properties encryptProps = new Properties();
        encryptProps.setProperty("encrypt", "true");
        encryptProps.setProperty("validateCertificate", "false");
        return encryptProps;
    }

    public void setEncryptProperties(String value) {
        if (!this.encrypt) {
            this.checkPropsForEncrypt(value);
        }
        this.certificateValidation = !this.encrypt || value.toUpperCase(Locale.ENGLISH).indexOf("VALIDATECERTIFICATE=FALSE") == -1;
        this.encryptPropertiesString = value;
    }

    private void checkPropsForEncrypt(String string) {
        String[] props;
        for (String prop : props = string.split(",")) {
            String[] p = prop.split("=");
            if (p.length != 2 || !"ENCRYPT".equalsIgnoreCase(p[0])) continue;
            String value = p[1];
            if ("true".equalsIgnoreCase(value)) {
                this.encrypt = true;
            }
            return;
        }
    }

    private void setJDBCProperties(String value) {
        boolean validateCert;
        String[] props = value.split(",");
        for (int i = 0; i < props.length; ++i) {
            String[] prop = props[i].split("=");
            if ("ENCRYPT".equalsIgnoreCase(prop[0])) {
                this.properties.put("encrypt", prop[1]);
                continue;
            }
            if ("sslValidateCertificate".equalsIgnoreCase(prop[0])) {
                this.properties.put("validateCertificate", prop[1]);
                continue;
            }
            if ("sslCryptoProvider".equalsIgnoreCase(prop[0]) || !"authenticationX509".equalsIgnoreCase(prop[0])) continue;
            this.properties.put(prop[0], prop[1]);
        }
        boolean bl = validateCert = Boolean.parseBoolean(this.properties.getProperty("encrypt", "false")) && Boolean.parseBoolean(this.properties.getProperty("validateCertificate", "true"));
        if (validateCert) {
            for (int i = 0; i < props.length; ++i) {
                String file;
                String[] prop = props[i].split("=");
                if ("sslTrustStore".equalsIgnoreCase(prop[0])) {
                    file = this.findSecureFile(prop[1]);
                    if (this.checkFileExists(file)) {
                        this.properties.put("trustStore", new JavaKeystore().getTrustStore(file));
                        continue;
                    }
                    LogFactory.writeLogEntry(this.getClass(), "Specified certificate file  " + file + " not found. Truststore for JDBC will not be created.");
                    continue;
                }
                if ("sslKeyStore".equalsIgnoreCase(prop[0])) {
                    file = this.findSecureFile(prop[1]);
                    if (!this.checkFileExists(file)) continue;
                    this.properties.put("keyStore", new JavaKeystore().getKeyStore(file));
                    this.properties.put("keyStorePassword", new JavaKeystore().getKeyStorePassword());
                    continue;
                }
                if (!"sslHostNameInCertificate".equalsIgnoreCase(prop[0])) continue;
                this.properties.put("hostNameInCertificate", prop[1]);
            }
            if (!this.properties.containsKey("trustStore")) {
                LogFactory.writeLogEntry(this.getClass(), "Validate certificate is set, but no truststore is given or found. Looking for " + Sapgenpse.SAPCLI_PSE + " in environment variables.");
                String envvar = "HDB_PSE_PATH_FOR_JDBC";
                String pseLocation = System.getenv(envvar);
                if (null == pseLocation) {
                    envvar = "SECUDIR";
                    pseLocation = System.getenv(envvar);
                }
                if (null == pseLocation) {
                    LogFactory.writeLogEntry(this.getClass(), "Location for " + Sapgenpse.SAPCLI_PSE + " not set in connection properties. Set environment variable HDB_PSE_PATH_FOR_JDBC to a path containing a valid PSE file.");
                } else {
                    LogFactory.writeLogEntry(this.getClass(), "Possible location found in " + envvar + ", looking for " + Sapgenpse.SAPCLI_PSE + " in: " + pseLocation);
                    File sapcli = new File(pseLocation + "/" + Sapgenpse.SAPCLI_PSE);
                    if (sapcli.exists() && sapcli.isFile()) {
                        if (!this.properties.containsKey("trustStore")) {
                            LogFactory.writeLogEntry(this.getClass(), "sslTrustStore not given, using " + sapcli.getAbsolutePath());
                            this.properties.put("trustStore", new JavaKeystore().getTrustStore(sapcli.getAbsolutePath()));
                        }
                        if (!this.properties.containsKey("keyStore")) {
                            LogFactory.writeLogEntry(this.getClass(), "sslKeyStore not given, using " + sapcli.getAbsolutePath());
                            this.properties.put("keyStore", new JavaKeystore().getKeyStore(sapcli.getAbsolutePath()));
                            this.properties.put("keyStorePassword", new JavaKeystore().getKeyStorePassword());
                        }
                    } else {
                        LogFactory.writeLogEntry(this.getClass(), "sapcli.pse not found in: " + pseLocation + ". Please check security settings.");
                        String store = new JavaKeystore().getDefaultTrustStore();
                        if (store != null) {
                            this.properties.put("trustStore", store);
                        }
                        if ((store = new JavaKeystore().getDefaultKeyStore()) != null) {
                            this.properties.put("keyStore", store);
                            this.properties.put("keyStorePassword", new JavaKeystore().getKeyStorePassword());
                        }
                    }
                }
            }
        }
    }

    private String findSecureFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        if (!file.isAbsolute()) {
            String secudir = System.getenv("SECUDIR");
            if (null == secudir) {
                LogFactory.writeLogEntry(this.getClass(), "Specified store " + fileName + " is not an absolute path and $SECUDIR is not set. Store not set.");
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Specified store " + fileName + " is not an absolute path. Looking for file in " + secudir + ".");
                File pse = new File(secudir + "/" + file.getName());
                if (pse.exists()) {
                    return pse.getAbsolutePath();
                }
            }
        }
        return fileName;
    }

    private boolean checkFileExists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public boolean validateCertificate() {
        return this.certificateValidation;
    }

    public void setForceEncrypt(String force) {
        this.forceEncrypt = force.equalsIgnoreCase("true") || force.equalsIgnoreCase("1") || force.equalsIgnoreCase("yes");
    }

    public boolean getForceEncrypt() {
        return this.forceEncrypt;
    }

    public boolean supportsClientPKI(JdbcConnection connection) {
        return connection.supportsClientPKI();
    }

    public boolean generatePKI(JdbcConnection connection) throws SQLException {
        String val;
        String count = "SELECT COUNT(*) FROM CERTIFICATES WHERE CERTIFICATE_NAME = '_SYS_CLIENTPKI_ROOT_CERT'";
        String update = "ALTER SYSTEM CLIENTPKI UPDATE ROOT CA";
        PreparedStatement statement = connection.prepareSQLCommand(count);
        ResultSet rs = statement.executeQuery();
        boolean updated = false;
        if (rs.next() && "0".equals(val = rs.getString(1))) {
            LogFactory.writeLogEntry(this.getClass(), "No certificate for the client PKI found. Updating ROOT CA...");
            Statement updateSQL = connection.createStatement();
            updated = updateSQL.execute(update);
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPKI(JdbcConnection connection, boolean generate) {
        ResultSet resultSet;
        PreparedStatement statement;
        String val;
        block9: {
            String pki = "clientpki_" + this.getSid().toString() + ".cer";
            String sql = "SELECT CERTIFICATE FROM CERTIFICATES WHERE CERTIFICATE_NAME = '_SYS_CLIENTPKI_ROOT_CERT'";
            val = null;
            statement = null;
            resultSet = null;
            try {
                if (generate) {
                    this.generatePKI(connection);
                }
                statement = connection.prepareSQLCommand(sql);
                LogFactory.writeLogEntry(this.getClass(), "Executing [" + sql + "]...");
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    val = resultSet.getString(1);
                    LogFactory.writeLogEntry(this.getClass(), "Writing client PKI to file: " + pki);
                    try {
                        File pkifile = new File(pki);
                        if (pkifile.exists()) {
                            pkifile.delete();
                        }
                        BufferedWriter writer = new BufferedWriter(new FileWriter(pki, true));
                        writer.append(val);
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block9;
                }
                LogFactory.writeLogEntry(this.getClass(), "No PKI found.");
            }
            catch (Exception e) {
                try {
                    LogFactory.writeLogEntry(this.getClass(), "Error execute SQL Statement: \"" + sql + "\". " + " [" + e.getMessage() + "]");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resultSet);
                    IOUtils.closeQuietly(statement);
                    throw throwable;
                }
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        return val;
    }

    public static enum UsageType {
        TRACE,
        DATA,
        DATA_BACKUP,
        LOG,
        LOG_BACKUPplusCATALOG_BACKUP;

    }

    public static enum DatabaseMode {
        SINGLE,
        MULTIPLE;

    }
}

