/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.List;
import java.util.Locale;

public class DatabaseAudit {
    private String global_auditing_state = "true";
    private int auditEntries = 0;
    private int S4HANAAuditEntries = 0;
    private String nameInScript = "S4HANA_CREATE_AUDIT_POLICIES";
    private String procName = "#" + this.nameInScript;

    public DatabaseAudit(JdbcConnection connection, DatabaseUser sqlUser) {
        this.set(connection, sqlUser);
    }

    public void set(JdbcConnection connection, DatabaseUser user) {
        this.global_auditing_state = this.checkAuditConfiguration(connection, user);
        this.auditEntries = this.countDistinctAuditEntries(connection);
        this.S4HANAAuditEntries = this.countDistinctS4HANAAuditEntries(connection);
        LogFactory.writeLogEntry(this.getClass(), "global_auditing_state [" + this.global_auditing_state + "]:" + " Found " + this.auditEntries + " existing audit policy entries (S/4HANA entries: " + this.S4HANAAuditEntries + ").");
    }

    private String checkAuditConfiguration(JdbcConnection connection, DatabaseUser user) {
        LogFactory.writeLogEntry(this.getClass(), "Checking auditing configuration...");
        DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection section = config.getSection("auditing configuration");
        return section.getParameterValue("global_auditing_state", "true");
    }

    public boolean setAuditStateOn(JdbcConnection connection, DatabaseUser user) {
        return this.setAuditState(connection, user, "true");
    }

    public boolean setAuditStateOff(JdbcConnection connection, DatabaseUser user) {
        return this.setAuditState(connection, user, "false");
    }

    public boolean setAuditState(JdbcConnection connection, DatabaseUser user, String state) {
        if (!this.global_auditing_state.equalsIgnoreCase(state.toLowerCase(Locale.ENGLISH))) {
            DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
            DatabaseConfigurationSection section = config.getSection("auditing configuration");
            section.setParameter("global_auditing_state", state);
            this.global_auditing_state = this.checkAuditConfiguration(connection, user);
            LogFactory.writeLogEntry(this.getClass(), "Auditing state configuration set. global_auditing_state [" + this.global_auditing_state + "].");
        } else {
            LogFactory.writeLogEntry(this.getClass(), "Auditing state configuration already set. global_auditing_state [" + this.global_auditing_state + "].");
        }
        return this.global_auditing_state.equalsIgnoreCase(state.toLowerCase(Locale.ENGLISH));
    }

    public boolean isAuditingOn() {
        return Boolean.parseBoolean(this.global_auditing_state);
    }

    public void setAuditPolicies(JdbcConnection connection, String fileContent) {
        int entriesBefore = this.countDistinctAuditEntries(connection);
        if (!this.hasAuditAdminSystemPrivilege(connection)) {
            LogFactory.writeLogEntry(this.getClass(), "Audit policies cannot be set. Current user is missing system privilege 'AUDIT ADMIN'.");
            return;
        }
        if (fileContent.indexOf("CREATE PROCEDURE " + this.nameInScript + "(") > -1) {
            String proc = fileContent.replace("CREATE PROCEDURE " + this.nameInScript + "(", "CREATE PROCEDURE " + this.procName + "(");
            connection.executeSQLCommand("DROP PROCEDURE " + this.procName, true);
            connection.executeSQLCommand(proc);
            connection.executeSQLCommand("CALL " + this.procName + "()");
        } else {
            LogFactory.writeLogEntry(this.getClass(), "The expected name for the store procedure in script is not found. Continue without adding audit policies.");
        }
        LogFactory.writeLogEntry(this.getClass(), "Set audit policy for S/4 HANA executed. New distinct entries created: " + (this.countDistinctAuditEntries(connection) - entriesBefore));
    }

    private boolean hasAuditAdminSystemPrivilege(JdbcConnection connection) {
        String sql = "SELECT HASSYSTEMPRIVILEGE(CURRENT_USER, 'AUDIT ADMIN') FROM SYS.DUMMY";
        List<String> result = connection.executeSQLCommand(sql);
        return result.get(0).equals("1");
    }

    private int countDistinctAuditEntries(JdbcConnection connection) {
        List<String> result = connection.executeSQLCommand("SELECT COUNT(DISTINCT AUDIT_POLICY_NAME) FROM \"SYS\".\"AUDIT_POLICIES\"");
        String c = result.get(0);
        return Integer.parseInt(c);
    }

    private int countDistinctS4HANAAuditEntries(JdbcConnection connection) {
        List<String> result = connection.executeSQLCommand("SELECT COUNT(DISTINCT AUDIT_POLICY_NAME) FROM \"SYS\".\"AUDIT_POLICIES\" WHERE  AUDIT_POLICY_NAME LIKE '_SAP%'");
        String c = result.get(0);
        return Integer.parseInt(c);
    }
}

