/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSectionMultiDB;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSectionSingleDB;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.Locale;

public class DatabaseConfiguration {
    private JdbcConnection connection = null;
    private ConfigFileName fileName = null;

    public DatabaseConfiguration(JdbcConnection connection, DatabaseUser connectUser, ConfigFileName configFileName) {
        connection.setConnectUser(connectUser);
        this.connection = connection;
        this.fileName = configFileName;
    }

    public DatabaseConfigurationSection getSection(String sectionName) {
        if (this.connection.isMultiDB()) {
            return new DatabaseConfigurationSectionMultiDB(this.connection, this.fileName, sectionName);
        }
        return new DatabaseConfigurationSectionSingleDB(this.connection, this.fileName, sectionName);
    }

    public static enum ConfigFileName {
        INDEXSERVER_INI,
        GLOBAL_INI,
        XSENGINE_INI,
        EXECUTOR_INI,
        DAEMON_INI,
        EXTENSIONS_INI,
        PREPROCESSOR_INI,
        LOCALCLIENT_INI,
        FILTER_INI,
        SCRIPTSERVER_INI,
        STATISTICSSERVER_INI,
        ATTRIBUTES_INI,
        NAMESERVER_INI;


        public String toString() {
            String result = super.toString();
            result = result.toLowerCase(Locale.ENGLISH);
            result = result.replace("_", ".");
            return result;
        }

        public static ConfigFileName fromString(String string) {
            return ConfigFileName.valueOf(string.replace(".", "_").toUpperCase(Locale.ENGLISH));
        }
    }
}

