/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseConfigurationSectionMultiDB
implements DatabaseConfigurationSection {
    private JdbcConnection connection = null;
    private String sectionName = null;
    private DatabaseConfiguration.ConfigFileName fileName = null;
    static String indexserverPort = null;

    protected DatabaseConfigurationSectionMultiDB(JdbcConnection connection, DatabaseConfiguration.ConfigFileName fileName, String sectionName) {
        this.connection = connection;
        this.sectionName = sectionName;
        this.fileName = fileName;
    }

    @Override
    public boolean isParameterSet(String name) {
        String result = this.getParameterValue(name);
        return result != null;
    }

    @Override
    public String getParameterValue(String name, String default_value) {
        String value = this.getParameterValue(name);
        if (null == value && default_value != null) {
            value = default_value;
        }
        return value;
    }

    @Override
    public String getParameterValue(String name) {
        if (!this.connection.isConnectedToSystemDB() && this.connection.isProductVersionEqualOrGreaterThan("2.00.040") && this.fileName.equals((Object)DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI)) {
            return this.getParameterValueLandscape(name);
        }
        this.connection.setLogging(false);
        List<String> host = this.connection.executeSQLCommand("SELECT HOST FROM \"PUBLIC\".\"M_LANDSCAPE_HOST_CONFIGURATION\" WHERE HOST_STATUS = 'OK' AND INDEXSERVER_ACTUAL_ROLE IN ('MASTER', 'COORDINATOR')");
        String master = null;
        if (host.size() == 1) {
            master = host.get(0);
        }
        List<String> result = Collections.emptyList();
        if (master != null) {
            result = this.connection.executeSQLCommand("SELECT VALUE FROM \"PUBLIC\".\"M_INIFILE_CONTENTS\" WHERE FILE_NAME = '" + (Object)((Object)this.fileName) + "' AND SECTION = '" + this.sectionName + "' AND KEY = '" + name + "' AND LAYER_NAME = 'HOST' AND HOST = '" + master + "'");
        }
        if (result.size() == 0) {
            result = this.connection.executeSQLCommand("SELECT VALUE FROM \"PUBLIC\".\"M_INIFILE_CONTENTS\" WHERE FILE_NAME = '" + (Object)((Object)this.fileName) + "' AND SECTION = '" + this.sectionName + "' AND KEY = '" + name + "' AND LAYER_NAME = 'DATABASE'");
        }
        if (result.size() == 0) {
            result = this.connection.executeSQLCommand("SELECT VALUE FROM \"PUBLIC\".\"M_INIFILE_CONTENTS\" WHERE FILE_NAME = '" + (Object)((Object)this.fileName) + "' AND SECTION = '" + this.sectionName + "' AND KEY = '" + name + "' AND LAYER_NAME = 'SYSTEM'");
        }
        if (result.size() == 0 || !this.validate(this.getValue(result), name)) {
            result = this.connection.executeSQLCommand("SELECT VALUE FROM \"PUBLIC\".\"M_INIFILE_CONTENTS\" WHERE FILE_NAME = '" + (Object)((Object)this.fileName) + "' AND SECTION = '" + this.sectionName + "' AND KEY = '" + name + "' AND LAYER_NAME = 'DEFAULT'");
        }
        this.connection.setLogging(true);
        return this.getValue(result);
    }

    public String getParameterValueLandscape(String name) {
        List<String> ports;
        this.connection.setLogging(false);
        if (null == indexserverPort && (ports = this.connection.executeSQLCommand("SELECT PORT FROM SYS.M_SERVICES WHERE SERVICE_NAME = 'indexserver'")).size() > 0) {
            indexserverPort = ports.get(0);
        }
        List<Object> result = Collections.emptyList();
        String sql = "SELECT VALUE FROM \"PUBLIC\".\"M_CONFIGURATION_PARAMETER_VALUES\" WHERE FILE_NAME = '" + (Object)((Object)this.fileName) + "' AND SECTION = '" + this.sectionName + "' AND KEY = '" + name + "'";
        if (null != indexserverPort && !indexserverPort.isEmpty()) {
            sql = sql + " AND PORT = '" + indexserverPort + "'";
        }
        result = this.connection.executeSQLCommand(sql);
        this.connection.setLogging(true);
        if (result.size() == 1) {
            return (String)result.get(0);
        }
        if (result.size() >= 2) {
            return (String)result.get(1);
        }
        return null;
    }

    @Override
    public void setParameter(String name, String value) {
        if (this.isParameterSet(name) && this.getParameterValue(name).equals(value)) {
            this.localLogger("HANA parameter '" + name + "' has already value '" + value + "'. Therefore, the parameter does not need to be set explicitly.");
        } else {
            String stmnt = "ALTER SYSTEM ALTER CONFIGURATION ('" + (Object)((Object)this.fileName) + "', 'SYSTEM' ) SET ('" + this.sectionName + "', '" + name + "') = '" + value + "' WITH RECONFIGURE";
            this.connection.executeSQLCommand(stmnt);
        }
    }

    @Override
    public void unsetParameter(String name) {
        if (this.isParameterSet(name)) {
            String stmnt = "ALTER SYSTEM ALTER CONFIGURATION ('" + (Object)((Object)this.fileName) + "','SYSTEM') UNSET ('" + this.sectionName + "','" + name + "') WITH RECONFIGURE";
            this.connection.executeSQLCommand(stmnt);
        } else {
            this.localLogger("HANA parameter '" + name + "' is not set. Nothing to do for unset.");
        }
    }

    @Override
    public HashMap<String, String> getParameters(String[] parameterNames) {
        HashMap<String, String> parameterBackup = new HashMap<String, String>();
        for (String name : parameterNames) {
            if (!this.isParameterSet(name)) continue;
            parameterBackup.put(name, this.getParameterValue(name));
        }
        return parameterBackup;
    }

    @Override
    public void setParameters(Map<String, String> parameterBackup) {
        for (Map.Entry<String, String> e : parameterBackup.entrySet()) {
            this.setParameter(e.getKey(), e.getValue());
        }
    }

    private boolean validate(String value, String parameterName) {
        boolean ok = true;
        if ("minimal_password_length".equals(parameterName)) {
            try {
                int num = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.localLogger("Unexpected value '" + value + "' for configuration parameter '" + parameterName + "' found, using default configuration value instead." + " See the SAP HANA Administration Guide and correctly set the configuration parameter.");
                ok = false;
            }
        }
        return ok;
    }

    private String getValue(List<String> result) {
        if (result.size() == 1) {
            return result.get(0);
        }
        if (result.size() == 2) {
            return result.get(1);
        }
        return null;
    }

    private void localLogger(String logText) {
        LogFactory.writeLogEntry(this.getClass(), logText);
    }
}

