/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.ArrayList;
import java.util.Arrays;

public class DatabaseConfigurationsHelper {
    static String[][] defaultConfigurations = new String[][]{{"INDEXSERVER.INI", "dynamic_result_cache", "enable_implicit_match", "true", "754", "754"}, {"INDEXSERVER.INI", "sqlscript", "enable_builtin_procedure_get_objects_in_ddl_statement", "true", "753", "754"}};

    public static ArrayList<String[]> checkConfigurations(JdbcConnection connection, DatabaseSqlUser sqlUser) {
        ArrayList<String[]> configs = DatabaseConfigurationsHelper.getConfigurations(connection, sqlUser);
        ArrayList<String[]> missingConfigurations = new ArrayList<String[]>();
        for (Object[] objectArray : configs) {
            int basis;
            DatabaseConfiguration config = new DatabaseConfiguration(connection, sqlUser, DatabaseConfiguration.ConfigFileName.fromString(objectArray[0]));
            DatabaseConfigurationSection section = config.getSection(objectArray[1]);
            String paramValue = section.getParameterValue(objectArray[2]);
            if (objectArray.length <= 4 || (basis = BasisUtils.checkCVERSBasisRelease(connection, sqlUser)) <= 0) continue;
            int from_basis = Integer.parseInt(objectArray[4]);
            if (!(from_basis > basis || paramValue != null && paramValue.equalsIgnoreCase(objectArray[3]))) {
                if (objectArray.length > 5) {
                    int valid_to_basis = Integer.parseInt((String)objectArray[5]);
                    if (basis > valid_to_basis || paramValue != null && paramValue.equalsIgnoreCase((String)objectArray[3])) continue;
                    missingConfigurations.add((String[])objectArray);
                    continue;
                }
                missingConfigurations.add((String[])objectArray);
                continue;
            }
            LogFactory.writeLogEntry(DatabaseConfigurationsHelper.class, "Configuration already done or not needed: " + Arrays.toString(objectArray));
        }
        return missingConfigurations;
    }

    public static ArrayList<String[]> getConfigurations(JdbcConnection connection, DatabaseUser sqlUser) {
        ArrayList<String[]> configs = new ArrayList<String[]>();
        for (String[] defaultConfig : defaultConfigurations) {
            configs.add(defaultConfig);
        }
        return configs;
    }
}

