/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.List;
import java.util.Locale;

public class DatabaseLogMode {
    public static String NORMAL = "normal";
    public static String OVERWRITE = "overwrite";
    private boolean fullBackupExists = true;
    public String log_mode = null;

    public void check(JdbcConnection connection, DatabaseUser user) {
        this.checkForFullBackup(connection);
        this.checkConfiguration(connection, user);
    }

    private void checkForFullBackup(JdbcConnection connection) {
        List<String> result = connection.executeSQLCommand("SELECT count(*) from SYS.M_BACKUP_CATALOG where ENTRY_TYPE_NAME = 'complete data backup' and STATE_NAME = 'successful'");
        String c = result.get(0);
        int count = Integer.parseInt(c);
        if (0 == count) {
            this.fullBackupExists = false;
            LogFactory.writeLogEntry(this.getClass(), "No full data backup found.");
        } else {
            this.fullBackupExists = true;
            LogFactory.writeLogEntry(this.getClass(), "Full data backup exists.");
        }
    }

    private void checkConfiguration(JdbcConnection connection, DatabaseUser user) {
        LogFactory.writeLogEntry(this.getClass(), "Checking log_mode configuration...");
        DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection section = config.getSection("persistence");
        this.log_mode = section.getParameterValue("log_mode");
        LogFactory.writeLogEntry(this.getClass(), "Found log_mode: " + this.log_mode);
    }

    public boolean setLogMode(JdbcConnection connection, DatabaseUser user, String mode) {
        DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection section = config.getSection("persistence");
        section.setParameter("log_mode", mode);
        this.checkConfiguration(connection, user);
        return null != this.log_mode && this.log_mode.equalsIgnoreCase(mode.toLowerCase(Locale.ENGLISH));
    }

    public boolean fullBackupExists() {
        return this.fullBackupExists;
    }

    public boolean isLogModeNormal() {
        return null != this.log_mode && this.log_mode.equalsIgnoreCase(NORMAL);
    }

    public boolean isLogModeOverwrite() {
        return null != this.log_mode && this.log_mode.equalsIgnoreCase(OVERWRITE);
    }

    public boolean isLogModeNull() {
        return null == this.log_mode;
    }
}

