/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Port;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class DatabasePort
extends Port {
    private static int MIN_SQL_PORT_NUMBER = 30000;
    private static int MAX_SQL_PORT_NUMBER = 99999;

    public DatabasePort(String port) {
        super(port);
        port = port.trim();
        try {
            this.validateSQLPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            throw new HdbException(port + " not a valid Port number!");
        }
        if (!port.startsWith("3")) {
            throw new HdbException(port + " port number must start with 3!");
        }
        this.port = port;
    }

    public DatabasePort(CmdClazzParameterMap parameters) {
        this(parameters.get(CmdClazzParameterName.PORT).getValue());
    }

    private void validateSQLPort(int portNumberToValidate) {
        if (portNumberToValidate < MIN_SQL_PORT_NUMBER) {
            throw new HdbException(portNumberToValidate + " port number is too small!");
        }
        if (portNumberToValidate > MAX_SQL_PORT_NUMBER) {
            throw new HdbException(portNumberToValidate + " port number is too high!");
        }
    }

    public static boolean isValidSQLPort(String portNumber) {
        if (portNumber == null) {
            return false;
        }
        int portNumberToValidate = Integer.parseInt(portNumber.trim());
        return portNumberToValidate >= MIN_SQL_PORT_NUMBER || portNumberToValidate <= MAX_SQL_PORT_NUMBER;
    }

    @Override
    public String get() {
        return this.port;
    }

    public Integer getAsInteger() {
        return Integer.valueOf(this.port);
    }
}

