/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.HdbVersionHelper;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class DatabaseReorg {
    protected final DatabaseSqlUser sqlUser;
    protected final String schemaName;
    private String reorgTableName;
    private HdbVersion databaseVersion;

    public DatabaseReorg(DatabaseSqlUser sqlUser, HdbVersion databaseVersion) {
        this.sqlUser = sqlUser;
        this.schemaName = sqlUser.getName().get();
        String tableName = this.schemaName + ".SWPM_REORG_INPUT_TABLE_" + Long.toHexString(UUID.randomUUID().getMostSignificantBits());
        this.reorgTableName = tableName.toUpperCase(Locale.ENGLISH);
        LogFactory.writeLogEntry(this.getClass(), "Tablename for redistribution input will be: " + this.reorgTableName);
        this.databaseVersion = databaseVersion;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTableClassifications(final JdbcDriver driver, final Database instance, final File tableClassificationFile, long timeout) {
        this.assertLegalState();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(tableClassificationFile));
            ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            ArrayList<Future<TableClassificationTaskResult>> tasks = new ArrayList<Future<TableClassificationTaskResult>>();
            int numberOfColumns = 4;
            while ((line = br.readLine()) != null) {
                String tableRow = line.trim();
                if (tableRow.isEmpty()) continue;
                final String[] csv = tableRow.split(";", -1);
                if (csv.length != numberOfColumns) {
                    throw new HdbException("Invalid line: " + tableRow + ". A line must have " + numberOfColumns + " fields.");
                }
                Callable<TableClassificationTaskResult> tableClassificationTask = new Callable<TableClassificationTaskResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public TableClassificationTaskResult call() throws Exception {
                        String alterTableStatementString;
                        Connection connection;
                        ResultSet checkTableExistenceResultSet;
                        PreparedStatement checkTableExistenceStatement;
                        PreparedStatement alterTableStatement;
                        TableClassificationTaskResult info;
                        block9: {
                            String groupSubType;
                            String groupType;
                            String groupName;
                            String tableName;
                            block8: {
                                block7: {
                                    tableName = csv[0].trim();
                                    info = new TableClassificationTaskResult(tableName);
                                    groupName = csv[1].trim();
                                    groupType = csv[2].trim();
                                    groupSubType = csv[3].trim();
                                    alterTableStatement = null;
                                    checkTableExistenceStatement = null;
                                    checkTableExistenceResultSet = null;
                                    connection = null;
                                    JdbcConnection jdbcConnection = JdbcConnectionFactory.getUniqueInstance(driver, instance);
                                    jdbcConnection.setConnectUser(DatabaseReorg.this.sqlUser);
                                    connection = jdbcConnection.getConnection();
                                    checkTableExistenceStatement = connection.prepareStatement("SELECT COUNT(*) FROM \"PUBLIC\".\"M_TABLES\" WHERE SCHEMA_NAME=? AND TABLE_NAME=?");
                                    checkTableExistenceStatement.setString(1, DatabaseReorg.this.schemaName);
                                    checkTableExistenceStatement.setString(2, tableName);
                                    checkTableExistenceResultSet = checkTableExistenceStatement.executeQuery();
                                    if (!checkTableExistenceResultSet.next()) break block7;
                                    if (checkTableExistenceResultSet.getInt(1) != 0) break block8;
                                    LogFactory.writeLogEntry(DatabaseReorg.class, "The table '" + tableName + "' was found in file '" + tableClassificationFile.getAbsolutePath() + "' but doesn't exist in the database.");
                                    TableClassificationTaskResult tableClassificationTaskResult = info;
                                    IOUtils.closeQuietly(checkTableExistenceResultSet);
                                    IOUtils.closeQuietly(checkTableExistenceStatement);
                                    IOUtils.closeQuietly(alterTableStatement);
                                    IOUtils.closeQuietly(connection);
                                    return tableClassificationTaskResult;
                                }
                                info.setException(new HdbException("An error occurred while determining whether table '" + tableName + "' exists."));
                                TableClassificationTaskResult tableClassificationTaskResult = info;
                                IOUtils.closeQuietly(checkTableExistenceResultSet);
                                IOUtils.closeQuietly(checkTableExistenceStatement);
                                IOUtils.closeQuietly(alterTableStatement);
                                IOUtils.closeQuietly(connection);
                                return tableClassificationTaskResult;
                            }
                            alterTableStatementString = this.getAlterTableStatement(tableName, groupType, groupName, groupSubType);
                            if (alterTableStatementString != null) break block9;
                            LogFactory.writeLogEntry(DatabaseReorg.class, "The table classification information for table '" + tableName + "' in file '" + tableClassificationFile.getAbsolutePath() + "' was empty.");
                            TableClassificationTaskResult tableClassificationTaskResult = info;
                            IOUtils.closeQuietly(checkTableExistenceResultSet);
                            IOUtils.closeQuietly(checkTableExistenceStatement);
                            IOUtils.closeQuietly(alterTableStatement);
                            IOUtils.closeQuietly(connection);
                            return tableClassificationTaskResult;
                        }
                        try {
                            LogFactory.writeLogEntry(DatabaseReorg.class, "Executing statement: " + alterTableStatementString);
                            alterTableStatement = connection.prepareStatement(alterTableStatementString);
                            alterTableStatement.executeUpdate();
                        }
                        catch (Exception e) {
                            try {
                                info.setException(e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(checkTableExistenceResultSet);
                                IOUtils.closeQuietly(checkTableExistenceStatement);
                                IOUtils.closeQuietly(alterTableStatement);
                                IOUtils.closeQuietly(connection);
                                throw throwable;
                            }
                            IOUtils.closeQuietly(checkTableExistenceResultSet);
                            IOUtils.closeQuietly(checkTableExistenceStatement);
                            IOUtils.closeQuietly(alterTableStatement);
                            IOUtils.closeQuietly(connection);
                        }
                        IOUtils.closeQuietly(checkTableExistenceResultSet);
                        IOUtils.closeQuietly(checkTableExistenceStatement);
                        IOUtils.closeQuietly(alterTableStatement);
                        IOUtils.closeQuietly(connection);
                        return info;
                    }

                    private String getAlterTableStatement(String table, String groupType, String groupName, String groupSubType) {
                        if (!(groupType != null && !groupType.isEmpty() || groupName != null && !groupName.isEmpty() || groupSubType != null && !groupSubType.isEmpty())) {
                            return null;
                        }
                        StringBuilder sb = new StringBuilder("ALTER TABLE \"" + table + "\" SET");
                        if (groupType != null && !groupType.isEmpty()) {
                            sb.append(" GROUP TYPE \"").append(groupType).append("\"");
                        }
                        if (groupName != null && !groupName.isEmpty()) {
                            sb.append(" GROUP NAME \"").append(groupName).append("\"");
                        }
                        if (groupSubType != null && !groupSubType.isEmpty()) {
                            sb.append(" GROUP SUBTYPE \"").append(groupSubType).append("\"");
                        }
                        return sb.toString();
                    }
                };
                Future<TableClassificationTaskResult> future = service.submit(tableClassificationTask);
                tasks.add(future);
            }
            service.shutdown();
            TimeUnit unit = TimeUnit.MINUTES;
            boolean terminated = service.awaitTermination(timeout, unit);
            if (!terminated) {
                throw new HdbException("The table classification tasks did not complete within " + timeout + " " + unit.toString().toLowerCase(Locale.ENGLISH));
            }
            for (Future future : tasks) {
                TableClassificationTaskResult info = (TableClassificationTaskResult)future.get();
                Exception e = info.getException();
                if (e == null) continue;
                throw new HdbException("An error occurred during the classification of table '" + info.getTableName() + "': " + e.getMessage(), e);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new HdbException("Table classification file '" + tableClassificationFile + "' does not exist.", e);
                catch (IOException e2) {
                    throw new HdbException("Error reading table classification file: " + e2.getMessage(), e2);
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                    throw new HdbException("The current thread was interrupted while waiting for the table classification tasks to complete: " + e3.getMessage(), e3);
                }
                catch (ExecutionException e4) {
                    throw new HdbException("An error occurred while retrieving the result of a table classification task: " + e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(br);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillReorgTable(Connection connection, File tableFile, boolean nw740Format) {
        this.assertLegalState();
        PreparedStatement createStatement = null;
        PreparedStatement insertStatement = null;
        BufferedReader br = null;
        try {
            String line;
            int numberOfColumns;
            if (nw740Format) {
                createStatement = connection.prepareStatement("CREATE COLUMN TABLE " + this.reorgTableName + " (\"SCHEMA\" VARCHAR(256), \"TABLE\" VARCHAR(256), \"ESTIMATED_ROWS\" BIGINT, \"ESTIMATED_SIZE\" BIGINT, \"TOTAL_EXECUTION_TIME\" BIGINT, \"TOTAL_EXECUTION_COUNT\" BIGINT)");
                createStatement.executeUpdate();
                insertStatement = connection.prepareStatement("INSERT INTO " + this.reorgTableName + " VALUES (?,?,?,?,?,?)");
                numberOfColumns = 5;
            } else {
                createStatement = connection.prepareStatement("CREATE COLUMN TABLE " + this.reorgTableName + " (\"SCHEMA\" VARCHAR(256), \"TABLE\" VARCHAR(256), \"ESTIMATED_ROWS\" BIGINT, \"ESTIMATED_SIZE\" BIGINT)");
                createStatement.executeUpdate();
                insertStatement = connection.prepareStatement("INSERT INTO " + this.reorgTableName + " VALUES (?,?,?,?)");
                numberOfColumns = 2;
            }
            br = new BufferedReader(new FileReader(tableFile));
            while ((line = br.readLine()) != null) {
                String tableRow = line.trim();
                if (tableRow.isEmpty()) continue;
                String[] csv = tableRow.split(";");
                if (csv.length != numberOfColumns) {
                    throw new HdbException("Invalid line: " + tableRow + ". A line must have " + numberOfColumns + " fields.");
                }
                for (int i = 0; i < csv.length; ++i) {
                    csv[i] = csv[i].trim();
                }
                insertStatement.setString(1, this.schemaName);
                insertStatement.setString(2, csv[0]);
                try {
                    insertStatement.setLong(3, Long.parseLong(csv[1]));
                }
                catch (NumberFormatException e) {
                    throw new HdbException("Invalid line: " + tableRow + ". Reason: " + e.getMessage());
                }
                if (nw740Format) {
                    try {
                        insertStatement.setLong(4, Long.parseLong(csv[2]));
                    }
                    catch (NumberFormatException e) {
                        throw new HdbException("Invalid line: " + tableRow + ". Reason: " + e.getMessage());
                    }
                    try {
                        insertStatement.setLong(5, Long.parseLong(csv[3]));
                    }
                    catch (NumberFormatException e) {
                        throw new HdbException("Invalid line: " + tableRow + ". Reason: " + e.getMessage());
                    }
                    try {
                        insertStatement.setLong(6, Long.parseLong(csv[4]));
                    }
                    catch (NumberFormatException e) {
                        throw new HdbException("Invalid line: " + tableRow + ". Reason: " + e.getMessage());
                    }
                }
                insertStatement.setLong(4, 0L);
                insertStatement.executeUpdate();
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new HdbException("Table file '" + tableFile + "' does not exist.", e);
                catch (IOException e2) {
                    throw new HdbException("Error reading table file: " + e2.getMessage(), e2);
                }
                catch (SQLException e3) {
                    throw new HdbException("Error inserting reorg information into table: " + e3.getMessage() + "(Error code: " + e3.getErrorCode() + ")", e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(createStatement);
                IOUtils.closeQuietly(insertStatement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(createStatement);
        IOUtils.closeQuietly(insertStatement);
    }

    public boolean generatePlan(Connection connection) {
        this.assertLegalState();
        CallableStatement sqlCommand = null;
        try {
            String stmt = "CALL REORG_GENERATE(?,?)";
            sqlCommand = connection.prepareCall(stmt);
            String parameters = this.reorgTableName;
            if (this.databaseVersion.getMajorVersion() > 1 || this.databaseVersion.getMinorVersion() > 0 || this.databaseVersion.getRevision() > 90) {
                parameters = HdbVersionHelper.isBeforeHANA2SP03(this.databaseVersion) ? "SCHEMA_NAME=>" + this.schemaName + ";" + parameters : "ENABLE_MERGE=>FALSE;SCHEMA_NAME=>" + this.schemaName + ";" + parameters;
            }
            sqlCommand.setInt(1, 8);
            sqlCommand.setString(2, parameters);
            LogFactory.writeLogEntry(this.getClass(), "Generating reorg plan: " + stmt);
            LogFactory.writeLogEntry(this.getClass(), "Parameter 1 : 8");
            LogFactory.writeLogEntry(this.getClass(), "Parameter 2 : " + parameters);
            sqlCommand.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new HdbException("An error occurred while calling REORG_GENERATE: " + e.getMessage() + "(Error code: " + e.getErrorCode() + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sqlCommand);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(sqlCommand);
        return !this.isPlanEmpty(connection);
    }

    private boolean isPlanEmpty(Connection connection) {
        ResultSet result;
        PreparedStatement statement;
        block5: {
            statement = null;
            result = null;
            statement = connection.prepareStatement("SELECT count(*) FROM REORG_PLAN");
            result = statement.executeQuery();
            if (!result.next()) break block5;
            boolean bl = result.getInt(1) == 0;
            IOUtils.closeQuietly(result);
            IOUtils.closeQuietly(statement);
            return bl;
        }
        try {
            try {
                throw new HdbException("An error occurred while checking for a reorg plan: the result set is empty.");
            }
            catch (SQLException e) {
                throw new HdbException("An error occurred while checking the reorg plan status: " + e.getMessage() + "(Error code: " + e.getErrorCode() + ")", e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(result);
            IOUtils.closeQuietly(statement);
            throw throwable;
        }
    }

    public int executePlan(Connection connection) {
        this.assertLegalState();
        int reorgId = 0;
        CallableStatement command = null;
        try {
            String stmt = "CALL REORG_EXECUTE(?)";
            command = connection.prepareCall(stmt);
            command.registerOutParameter(1, 4);
            LogFactory.writeLogEntry(this.getClass(), "Executing reorg plan: " + stmt);
            command.executeUpdate();
            reorgId = command.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw new HdbException("An error occurred while calling REORG_EXECUTE: " + e.getMessage() + "(Error code: " + e.getErrorCode() + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(command);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(command);
        return reorgId;
    }

    public void waitForReorgCompletion(Connection connection, int reorgId, long timeout) {
        this.assertLegalState();
        String status = this.getReorgStatus(connection, reorgId);
        int currentTries = 0;
        while ("STARTED".equalsIgnoreCase(status) && (long)currentTries < timeout) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new HdbException("The current thread was interrupted while waiting for reorg completion.", e);
            }
            ++currentTries;
            status = this.getReorgStatus(connection, reorgId);
        }
        if ((long)currentTries >= timeout) {
            throw new HdbException("A timeout occurred while waiting for reorg completion. The reorg did not complete within " + timeout + " seconds.");
        }
    }

    private String getReorgStatus(Connection connection, int reorgId) {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            statement = null;
            rs = null;
            statement = connection.prepareStatement("SELECT STATUS FROM REORG_OVERVIEW WHERE REORG_ID=?");
            statement.setInt(1, reorgId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            String string = rs.getString("STATUS");
            IOUtils.closeQuietly(rs);
            IOUtils.closeQuietly(statement);
            return string;
        }
        try {
            try {
                throw new HdbException("No reorg status was found. The plan was either not started or the current user does not have enough access rights.");
            }
            catch (SQLException e) {
                throw new HdbException("An error roccurred while retrieving the status of the current reorg plan: " + e.getMessage() + "(Error code: " + e.getErrorCode() + ")", e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rs);
            IOUtils.closeQuietly(statement);
            throw throwable;
        }
    }

    public Map<String, String> getFailedTables(Connection connection, int reorgId) {
        this.assertLegalState();
        HashMap<String, String> result = new HashMap<String, String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT TABLE_NAME, ERROR FROM REORG_STEPS WHERE REORG_ID=? AND STATUS='FAILED'");
            statement.setInt(1, reorgId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String errorMessage = resultSet.getString("ERROR");
                result.put(tableName, errorMessage);
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException("An error roccurred while retrieving the status of the current reorg plan: " + e.getMessage() + "(Error code: " + e.getErrorCode() + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        return result;
    }

    public void dropInputTable(Connection connection) {
        this.assertLegalState();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("DROP TABLE " + this.reorgTableName);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new HdbException("An error roccurred while dropping the input table '" + this.reorgTableName + "': " + e.getMessage() + "(Error code: " + e.getErrorCode() + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(statement);
        this.reorgTableName = null;
    }

    private void assertLegalState() {
        if (this.reorgTableName == null) {
            throw new IllegalStateException("The reorg table has already been dropped.");
        }
    }

    public String getInputTableName() {
        return this.reorgTableName;
    }

    private static class TableClassificationTaskResult {
        private final String tableName;
        private Exception exception;

        public TableClassificationTaskResult(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }
}

