/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.List;
import java.util.Locale;

public class DatabaseService {
    private Instance.ServiceName serviceName;
    private JdbcConnection connection;

    public DatabaseService(Instance.ServiceName serviceName, JdbcConnection connection, DatabaseUser connectUser) {
        this.serviceName = serviceName;
        this.connection = connection;
        this.connection.setConnectUser(connectUser);
    }

    public String getName() {
        return this.serviceName.toString().toLowerCase(Locale.ENGLISH);
    }

    public boolean exists() {
        boolean exists = false;
        String statement = "SELECT COUNT(*) FROM SYS.M_SERVICES WHERE SERVICE_NAME = '" + this.getName() + "' AND COORDINATOR_TYPE IN ('MASTER', 'COORDINATOR')";
        List<String> result = this.connection.executeSQLCommand(statement);
        if (result.size() == 1) {
            String count = result.get(0);
            if (Integer.valueOf(count) > 0) {
                exists = true;
            }
        } else {
            throw new HdbException("Error during statement: " + statement + ", " + result.toString());
        }
        return exists;
    }

    public String getStatus() {
        String status = "";
        String name = this.getName();
        String statement = "SELECT ACTIVE_STATUS FROM SYS.M_SERVICES WHERE SERVICE_NAME = '" + name + "' AND COORDINATOR_TYPE IN ('MASTER', 'COORDINATOR')";
        List<String> result = this.connection.executeSQLCommand(statement);
        int resultSize = result.size();
        if (resultSize != 1) {
            throw new HdbException(resultSize + " Unexpected result size. Expected 1 for sql query: " + statement);
        }
        status = result.get(0);
        return status;
    }
}

