/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseService;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;

public class DatabaseStatisticsServer {
    private boolean isMultiDB(JdbcConnection connection, DatabaseSystemUser systemUser) {
        connection.setConnectUser(systemUser);
        return connection.isMultiDB();
    }

    private DatabaseConfigurationSection getSection(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfigurationSection section = null;
        if (this.isMultiDB(connection, systemUser)) {
            DatabaseConfiguration config = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
            section = config.getSection("statisticsserver");
        } else if (!this.doesStatisticsServerProcessExists(connection, systemUser)) {
            DatabaseConfiguration config = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.NAMESERVER_INI);
            section = config.getSection("statisticsserver");
        } else {
            DatabaseConfiguration config = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.STATISTICSSERVER_INI);
            section = config.getSection("statisticsserver_general");
        }
        return section;
    }

    public void setOff(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfigurationSection section = this.getSection(connection, systemUser);
        section.setParameter("active", "false");
    }

    public void setOn(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfigurationSection section = this.getSection(connection, systemUser);
        section.setParameter("active", "true");
    }

    public boolean isOn(JdbcConnection connection, DatabaseSystemUser systemUser) {
        boolean isOnline = false;
        DatabaseConfigurationSection section = this.getSection(connection, systemUser);
        String value = section.getParameterValue("active");
        if ("true".equalsIgnoreCase(value) || this.isMultiDB(connection, systemUser)) {
            isOnline = true;
        }
        return isOnline;
    }

    private boolean doesStatisticsServerProcessExists(JdbcConnection connection, DatabaseUser connectUser) {
        DatabaseService statService = new DatabaseService(Instance.ServiceName.STATISTICSSERVER, connection, connectUser);
        return statService.exists();
    }

    public static enum Mode {
        ON,
        OFF;

    }
}

