/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObject;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObjectType;
import com.sap.hdb.sl.lib.instance.DatabaseTable;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseSynonym
implements DatabaseCatalogObject {
    private String name = null;
    private final String schemaName = "PUBLIC";

    public DatabaseSynonym(String name) {
        this.name = name;
    }

    @Override
    public boolean exists(JdbcConnection connection) {
        return this.exists(connection.getConnection());
    }

    @Override
    public boolean exists(Connection connection) {
        boolean exists = false;
        PreparedStatement stmnt = null;
        ResultSet result = null;
        try {
            stmnt = connection.prepareStatement("SELECT COUNT(SYNONYM_NAME) FROM " + this.getMonitoringView().getFullNameQuoted() + " WHERE SYNONYM_NAME = ? AND SCHEMA_NAME = ?");
            stmnt.setString(1, this.name);
            stmnt.setString(2, this.schemaName);
            result = stmnt.executeQuery();
            while (result.next()) {
                int count = result.getInt(1);
                if (count <= 0) continue;
                exists = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(result);
                IOUtils.closeQuietly(stmnt);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(result);
        IOUtils.closeQuietly(stmnt);
        return exists;
    }

    public void create(JdbcConnection connection, DatabaseTable table) {
        connection.executeSQLCommand("CREATE PUBLIC SYNONYM " + this.name + " FOR " + table.getFullName());
    }

    @Override
    public String getFullName() {
        return this.schemaName + "." + this.name;
    }

    @Override
    public String getFullNameQuoted() {
        return "\"" + this.schemaName + "\".\"" + this.name + "\"";
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public DatabaseCatalogObject getMonitoringView() {
        DatabaseTable table = new DatabaseTable("SYNONYMS");
        table.setSchemaName("PUBLIC");
        return table;
    }

    @Override
    public DatabaseCatalogObjectType getType() {
        return DatabaseCatalogObjectType.SYNONYM;
    }
}

