/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObject;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObjectType;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseTable
implements DatabaseCatalogObject {
    private String tableName = null;
    private String schemaName = null;

    public DatabaseTable(String tableName) {
        this(null, tableName);
    }

    public DatabaseTable(String schemaName, String tableName) {
        this.tableName = tableName;
        this.schemaName = schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public boolean exists(JdbcConnection connection) {
        return this.exists(connection.getConnection());
    }

    @Override
    public boolean exists(Connection connection) {
        boolean exists = false;
        PreparedStatement stmnt = null;
        ResultSet result = null;
        try {
            if (this.schemaName != null) {
                stmnt = connection.prepareStatement("SELECT COUNT(TABLE_NAME) FROM " + this.getMonitoringView().getFullNameQuoted() + " WHERE TABLE_NAME = ? AND SCHEMA_NAME = ?");
                stmnt.setString(1, this.tableName);
                stmnt.setString(2, this.schemaName);
            } else {
                stmnt = connection.prepareStatement("SELECT COUNT(TABLE_NAME) FROM " + this.getMonitoringView().getFullNameQuoted() + " WHERE TABLE_NAME = ?");
                stmnt.setString(1, this.tableName);
            }
            result = stmnt.executeQuery();
            while (result.next()) {
                int count = result.getInt(1);
                if (count <= 0) continue;
                exists = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(result);
                IOUtils.closeQuietly(stmnt);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(result);
        IOUtils.closeQuietly(stmnt);
        return exists;
    }

    @Override
    public String getFullName() {
        String fullName = "";
        fullName = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
        return fullName;
    }

    @Override
    public String getFullNameQuoted() {
        String fullName = "";
        fullName = this.schemaName != null ? "\"" + this.schemaName + "\".\"" + this.tableName + "\"" : "\"" + this.tableName + "\"";
        return fullName;
    }

    @Override
    public DatabaseCatalogObject getMonitoringView() {
        DatabaseTable table = new DatabaseTable("TABLES");
        table.setSchemaName("PUBLIC");
        return table;
    }

    @Override
    public DatabaseCatalogObjectType getType() {
        return DatabaseCatalogObjectType.TABLE;
    }
}

