/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcThreadExecuter;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabasePort;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DatabaseTenant {
    private Sid tenantName;
    private boolean dbIsolationLevelHigh = false;
    private String tenantOsUser = "";
    private String tenantOsGroup = "";

    protected DatabaseTenant(Sid tenantName, JdbcConnection connection) {
        this.tenantName = tenantName;
        if (!connection.isMultiDB()) {
            throw new HdbException(connection.toString() + ", database must be a multitenant database!");
        }
    }

    public boolean exists(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        boolean exists = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        int count = 0;
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        try {
            statement = connection.prepareSQLCommand("SELECT COUNT(*) FROM PUBLIC.M_DATABASES WHERE DATABASE_NAME=?");
            statement.setString(1, this.tenantName.get());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                LogFactory.writeLogEntry(this.getClass(), "Error determining SQL Port release: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        if (1 == count) {
            exists = true;
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tenantExists(JdbcConnection connection, DatabaseUser systemUser) {
        String result;
        ResultSet resultSet;
        PreparedStatement statement;
        block4: {
            statement = null;
            resultSet = null;
            result = null;
            this.setTenantData(connection, systemUser);
            try {
                statement = connection.prepareSQLCommand("SELECT DATABASE_NAME from M_DATABASE");
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block4;
                result = resultSet.getString("DATABASE_NAME");
            }
            catch (SQLException e) {
                block5: {
                    boolean bl;
                    try {
                        HdbException hdbe = new HdbException(e);
                        if (!hdbe.testDatabaseNotExists()) break block5;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(resultSet);
                        IOUtils.closeQuietly(statement);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(resultSet);
                    IOUtils.closeQuietly(statement);
                    return bl;
                }
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        return result.equals(this.tenantName.get());
    }

    public DatabasePort getSqlPort(JdbcConnection connection, DatabaseUser sqluser) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        String sqlPort = "";
        this.setTenantData(connection, sqluser);
        try {
            statement = connection.prepareSQLCommand("SELECT sql_port FROM M_SERVICES WHERE service_name = 'indexserver' AND coordinator_type IN ('MASTER', 'COORDINATOR')");
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                sqlPort = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                LogFactory.writeLogEntry(this.getClass(), "Error determining SQL Port release: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        if (sqlPort.isEmpty()) {
            throw new HdbException(this.tenantName + ", database doesn't have an SQL port in table SYS_DATABASES.M_SERVICES. Tenant database doesn't exist!");
        }
        return new DatabasePort(sqlPort);
    }

    public DatabasePort getPortWithSystemDB(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        String port = "";
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        try {
            statement = connection.prepareSQLCommand("SELECT PORT FROM SYS_DATABASES.M_SERVICES WHERE DATABASE_NAME = ? AND service_name = 'indexserver' AND coordinator_type = 'MASTER'");
            statement.setString(1, this.tenantName.get());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                port = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                LogFactory.writeLogEntry(this.getClass(), "Error determining SQL Port release: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        if (port.isEmpty()) {
            throw new HdbException(this.tenantName + ", database doesn't have an SQL port in table SYS_DATABASES.M_SERVICES. Tenant database doesn't exist!");
        }
        return new DatabasePort(port);
    }

    public void drop(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        connection.executeSQLCommand("DROP DATABASE " + this.tenantName);
    }

    public void create(JdbcConnection connection, DatabaseSqlUserPassword tenantSystemUserPassword, DatabaseSystemUser systemDatabaseUser) {
        this.create(connection, tenantSystemUserPassword, systemDatabaseUser, null);
    }

    public void create(JdbcConnection connection, DatabaseSqlUserPassword tenantSystemUserPassword, DatabaseSystemUser systemDatabaseUser, Hostname hostName) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        String tenantSystemUserPasswordWithoutSpecialChars = tenantSystemUserPassword.toString().replaceAll("\"", "\"\"");
        String statement = "CREATE DATABASE " + this.tenantName + (hostName != null ? " AT LOCATION '" + hostName + "'" : "") + " SYSTEM USER PASSWORD \"" + tenantSystemUserPasswordWithoutSpecialChars + "\"";
        if (this.isIsolationLevelHigh()) {
            statement = statement + " OS USER '" + this.getTenantOsUser() + "' OS GROUP '" + this.getTenantOsGroup() + "'";
        }
        connection.executeSQLCommand(statement);
    }

    public void create(JdbcConnection connection, DatabaseSqlUserPassword tenantSystemUserPassword, DatabaseSystemUser systemDatabaseUser, Hostname hostName, DatabasePort port) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        int comPort = port.getAsInteger();
        String tenantSystemUserPasswordWithoutSpecialChars = tenantSystemUserPassword.toString().replaceAll("\"", "\"\"");
        connection.executeSQLCommand("CREATE DATABASE " + this.tenantName + " AT LOCATION '" + hostName + ":" + comPort + "' " + " SYSTEM USER PASSWORD \"" + tenantSystemUserPasswordWithoutSpecialChars + "\"");
    }

    public void stop(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        try {
            connection.executeSQLCommand("ALTER SYSTEM STOP DATABASE " + this.tenantName);
        }
        catch (HdbException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("not stopped in time") > -1) {
                LogFactory.writeLogEntry(this.getClass(), "Tenant was not stopped in time. Retry a second time.");
                connection.executeSQLCommand("ALTER SYSTEM STOP DATABASE " + this.tenantName);
            }
            throw new HdbException(e.getMessage());
        }
    }

    public void start(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        connection.executeSQLCommand("ALTER SYSTEM START DATABASE " + this.tenantName);
    }

    public boolean isActive(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        boolean isActive = false;
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            String status;
            statement = connection.prepareSQLCommand("SELECT ACTIVE_STATUS from PUBLIC.M_DATABASES WHERE DATABASE_NAME = ?");
            statement.setString(1, this.tenantName.get());
            resultSet = statement.executeQuery();
            if (resultSet.next() && (status = resultSet.getString(1)).equals("YES")) {
                isActive = true;
            }
        }
        catch (SQLException e) {
            try {
                LogFactory.writeLogEntry(this.getClass(), "Error determining ACTIVE_STATUS: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
        return isActive;
    }

    public void startRecovery(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPath) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        if (this.isActive(connection, systemDatabaseUser)) {
            throw new HdbException("Tenant database " + this.tenantName + " must be offline!");
        }
        connection.executeSQLCommand("RECOVER DATA FOR " + this.tenantName + " USING FILE ('" + backupPath + "') CLEAR LOG");
    }

    public void startRecoveryAsync(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPath) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        if (this.isActive(connection, systemDatabaseUser)) {
            throw new HdbException("Tenant database " + this.tenantName + " must be offline!");
        }
        try {
            long start = System.nanoTime();
            String ts = this.getCurrentTimestamp(connection);
            Connection con = connection.cloneConnection();
            String sql = "RECOVER DATA FOR " + this.tenantName + " USING FILE ('" + backupPath + "') CLEAR LOG";
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + sql);
            JdbcThreadExecuter jte = new JdbcThreadExecuter(con, sql);
            String backup_id = this.getBackupID(connection, ts);
            jte.start();
            String dots = ".";
            for (int i = 1; jte.getErrorMessage() == null && backup_id.equals("") && i <= 10; ++i) {
                backup_id = this.getBackupID(connection, ts);
                System.out.println("Getting BACKUP_ID for the recovery action" + dots + " " + backup_id);
                Thread.sleep(2000L);
                dots = dots + ".";
            }
            int printIndex = 0;
            boolean printStatus = true;
            while (jte.isAlive()) {
                if (printStatus && printIndex < 10) {
                    ++printIndex;
                    printStatus = this.printRecoveryStatus(connection);
                    Thread.sleep(2000L);
                    continue;
                }
                printIndex = 0;
                System.out.println("Recovering data for database " + this.tenantName + " - BACKUP_ID: " + backup_id + ". Elapsed time: " + DatabaseTenant.duration(start, System.nanoTime(), false) + " minutes.");
                Thread.sleep(5000L);
            }
            con.close();
            if (jte.getErrorMessage() != null) {
                throw new HdbException(jte.getErrorMessage());
            }
            System.out.println("Recovery for database " + this.tenantName + " finished successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getCurrentTimestamp(JdbcConnection connection) {
        String query = "SELECT CURRENT_TIMESTAMP FROM DUMMY";
        String result = "";
        try {
            List<String> row = connection.executeSQLCommand(query, false);
            result = row.get(0);
        }
        catch (HdbException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getBackupID(JdbcConnection connection, String ts) {
        String query = "SELECT DISTINCT BACKUP_ID FROM sys_databases.M_recovery_progress where database_name = '" + this.tenantName + "' AND SYS_START_TIME > '" + ts + "'";
        String result = "";
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                result = rs.getString(1);
            }
            stmt.close();
        }
        catch (HdbException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean printRecoveryStatus(JdbcConnection connection) {
        String query = "SELECT SERVICE_NAME, PHASE_NAME, STATE_NAME, CURRENT_PROGRESS, MAX_PROGRESS AS PROGRESS FROM sys_databases.M_recovery_progress where database_name = '" + this.tenantName + "' ";
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            String row = "Progress: ";
            while (rs.next()) {
                String progress = "";
                if (rs.getLong(4) != 0L) {
                    progress = " | " + (int)((double)rs.getLong(4) / (double)rs.getLong(5) * 100.0) + "%";
                }
                row = row + rs.getString(1) + "[" + rs.getString(2) + " (" + rs.getString(3) + progress + ")], ";
            }
            System.out.println(row.substring(0, row.length() - 2));
            stmt.close();
        }
        catch (HdbException e) {
            return false;
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public static String duration(long start, long end, boolean millis) {
        long duration = TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS);
        long min = 0L;
        long sec = 0L;
        long msec = 0L;
        if (duration > 60000L) {
            min = TimeUnit.MINUTES.convert(duration, TimeUnit.MILLISECONDS);
            duration %= 60000L;
        }
        if (duration > 1000L) {
            sec = TimeUnit.SECONDS.convert(duration, TimeUnit.MILLISECONDS);
            duration %= 1000L;
        }
        msec = duration;
        return (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec + "0").substring(0, 2) + (millis ? "." + (msec + "000").substring(0, 3) : "");
    }

    public void startBackup(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPath) {
        this.startBackup(connection, systemDatabaseUser, backupPath, "");
    }

    public void startBackup(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPath, String options) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        connection.executeSQLCommand("BACKUP DATA FOR " + this.tenantName + " USING FILE ('" + backupPath + "') " + options);
    }

    public void startBackupBackint(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPrefix) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        connection.executeSQLCommand("BACKUP DATA FOR " + this.tenantName + " USING BACKINT ('" + backupPrefix + "')");
    }

    public List<String> getAllHostsWithConfigRoleMaster(JdbcConnection connection, DatabaseUser systemUser) {
        this.setTenantData(connection, systemUser);
        List<String> allHosts = connection.executeSQLCommand("SELECT HOST FROM M_SERVICES WHERE service_name = 'indexserver' AND coordinator_type IN ('MASTER', 'COORDINATOR') ");
        List<String> nodeListMaster = connection.executeSQLCommand("SELECT HOST FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE NAMESERVER_CONFIG_ROLE like 'MASTER%' ORDER BY NAMESERVER_ACTUAL_ROLE, NAMESERVER_CONFIG_ROLE");
        List<String> nodeListCoordinator = connection.executeSQLCommand("SELECT HOST FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE NAMESERVER_CONFIG_ROLE like 'COORDINATOR%' ORDER BY NAMESERVER_ACTUAL_ROLE, NAMESERVER_CONFIG_ROLE");
        for (String node : nodeListMaster) {
            if (allHosts.contains(node)) continue;
            allHosts.add(node);
        }
        for (String node : nodeListCoordinator) {
            if (allHosts.contains(node)) continue;
            allHosts.add(node);
        }
        return allHosts;
    }

    public String getPublicNameForHost(JdbcConnection connection, DatabaseUser sqlUser, String host) {
        this.setTenantData(connection, sqlUser);
        String key = "net_publicname";
        List<String> publicNameList = connection.executeSQLCommand("SELECT VALUE FROM \"PUBLIC\".\"M_HOST_INFORMATION\" WHERE HOST='" + host + "' AND KEY='" + key + "'");
        if (publicNameList.size() == 0) {
            LogFactory.writeLogEntry(this.getClass(), "No public name was found for host '" + host + "'. Using internal name.");
            return host;
        }
        if (publicNameList.size() == 1) {
            InetAddress address;
            String publicName = publicNameList.get(0);
            LogFactory.writeLogEntry(this.getClass(), "Resolving public name: " + publicName);
            try {
                address = InetAddress.getByName(publicName);
            }
            catch (UnknownHostException e) {
                String message = "An error occurred while resolving host " + publicName + ": " + e.getMessage();
                LogFactory.writeLogEntry(this.getClass(), message);
                throw new HdbException(message, e);
            }
            String hostName = address.getHostName();
            LogFactory.writeLogEntry(this.getClass(), "Found host name '" + hostName + "' for host '" + host + "'");
            return hostName;
        }
        String message = publicNameList.size() + " entries were found for host '" + host + "' and key '" + key + "', expected was 1. Please check your database configuration.";
        LogFactory.writeLogEntry(this.getClass(), message);
        throw new HdbException(message);
    }

    private void setSystemDatabaseData(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        connection.setSid(new Sid("SYSTEMDB"));
        connection.setConnectUser(systemDatabaseUser);
    }

    private void setTenantData(JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setSid(this.tenantName);
        connection.setConnectUser(sqlUser);
    }

    public void addService(Instance.ServiceName serviceName, Hostname hostName, DatabasePort port, JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        int comPort = port.getAsInteger();
        connection.executeSQLCommand("alter database " + this.tenantName.get() + " add '" + serviceName.toString().toLowerCase(Locale.ENGLISH) + "' at location '" + hostName + ":" + comPort + "'");
    }

    public List<Hostname> getSlaveHosts(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        ArrayList<Hostname> hostNames = new ArrayList<Hostname>();
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        PreparedStatement statement = connection.prepareSQLCommand("select HOST from SYS_DATABASES.M_SERVICES where COORDINATOR_TYPE = 'SLAVE' and DATABASE_NAME = ?");
        try {
            statement.setString(1, this.tenantName.get());
        }
        catch (SQLException e) {
            throw new HdbException(e.getMessage(), e);
        }
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            LogFactory.writeLogEntry(this.getClass(), "No slave nodes found for tenant: " + this.tenantName);
        } else {
            for (String node : result) {
                hostNames.add(new Hostname(node));
            }
        }
        return hostNames;
    }

    public Hostname getMasterHost(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        Hostname masterHost = null;
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        PreparedStatement statement = connection.prepareSQLCommand("select HOST from SYS_DATABASES.M_SERVICES where COORDINATOR_TYPE IN ('MASTER', 'COORDINATOR') and DATABASE_NAME = ?");
        try {
            statement.setString(1, this.tenantName.get());
        }
        catch (SQLException e) {
            throw new HdbException(e.getMessage(), e);
        }
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            throw new HdbException("No masterhost found for tenant: " + this.tenantName);
        }
        masterHost = new Hostname(result.get(0));
        return masterHost;
    }

    public Hostname getSystemDatabaseHost(JdbcConnection connection, DatabaseUser tenantSystemUserPassword) {
        Hostname systemDbHost = null;
        this.setTenantData(connection, tenantSystemUserPassword);
        PreparedStatement statement = connection.prepareSQLCommand("select HOST from M_SERVICES where SERVICE_NAME='nameserver' and COORDINATOR_TYPE IN ('MASTER', 'COORDINATOR')");
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            throw new HdbException("No result for '" + statement.toString() + "'. No system database host found!");
        }
        systemDbHost = new Hostname(result.get(0));
        return systemDbHost;
    }

    public Set<Hostname> getIndexserverHostsSystemDB(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser) {
        HashSet<Hostname> hostNames = new HashSet<Hostname>();
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        PreparedStatement statement = connection.prepareSQLCommand("select DISTINCT HOST from SYS_DATABASES.M_SERVICES where DATABASE_NAME = ?");
        try {
            statement.setString(1, this.tenantName.get());
        }
        catch (SQLException e) {
            throw new HdbException(e.getMessage(), e);
        }
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            throw new HdbException("No indexserver nodes found for tenant: " + this.tenantName);
        }
        for (String node : result) {
            hostNames.add(new Hostname(node));
        }
        return hostNames;
    }

    public Set<Hostname> getIndexserverHosts(JdbcConnection connection, DatabaseSystemUser systemUser) {
        HashSet<Hostname> hostNames = new HashSet<Hostname>();
        this.setTenantData(connection, systemUser);
        PreparedStatement statement = connection.prepareSQLCommand("select DISTINCT HOST from SYS.M_SERVICES");
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() == 0) {
            throw new HdbException("No indexserver nodes found for tenant: " + this.tenantName);
        }
        for (String node : result) {
            hostNames.add(new Hostname(node));
        }
        return hostNames;
    }

    public void startRecoveryBackint(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPrefix, Sid sourceDatabaseSid) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        String source = "";
        if (!sourceDatabaseSid.equals(this.tenantName)) {
            source = " USING SOURCE '" + sourceDatabaseSid.getValue() + "'";
        }
        if (this.isActive(connection, systemDatabaseUser)) {
            throw new HdbException("Tenant database " + this.tenantName + " must be offline!");
        }
        connection.executeSQLCommand("RECOVER DATA FOR " + this.tenantName + source + " USING BACKINT ('" + backupPrefix + "') CLEAR LOG");
    }

    public void startRecoveryBackintAsync(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, String backupPrefix, Sid sourceDatabaseSid) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        String source = "";
        if (!sourceDatabaseSid.equals(this.tenantName)) {
            source = " USING SOURCE '" + sourceDatabaseSid.getValue() + "'";
        }
        if (this.isActive(connection, systemDatabaseUser)) {
            throw new HdbException("Tenant database " + this.tenantName + " must be offline!");
        }
        try {
            long start = System.nanoTime();
            String ts = this.getCurrentTimestamp(connection);
            Connection con = connection.cloneConnection();
            String sql = "RECOVER DATA FOR " + this.tenantName + source + " USING BACKINT ('" + backupPrefix + "') CLEAR LOG";
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + sql);
            JdbcThreadExecuter jte = new JdbcThreadExecuter(con, sql);
            String backup_id = this.getBackupID(connection, ts);
            jte.start();
            String dots = ".";
            for (int i = 1; jte.getErrorMessage() == null && backup_id.equals("") && i <= 10; ++i) {
                backup_id = this.getBackupID(connection, ts);
                System.out.println("Getting BACKUP_ID for the recovery action" + dots + " " + backup_id);
                Thread.sleep(2000L);
                dots = dots + ".";
            }
            int printIndex = 0;
            boolean printStatus = true;
            while (jte.isAlive()) {
                if (printStatus && printIndex < 10) {
                    ++printIndex;
                    printStatus = this.printRecoveryStatus(connection);
                    Thread.sleep(2000L);
                    continue;
                }
                printIndex = 0;
                System.out.println("Recovering data for database " + this.tenantName + " - BACKUP_ID: " + backup_id + ". Elapsed time: " + DatabaseTenant.duration(start, System.nanoTime(), false) + " minutes.");
                Thread.sleep(5000L);
            }
            con.close();
            if (jte.getErrorMessage() != null) {
                throw new HdbException(jte.getErrorMessage());
            }
            System.out.println("Recovery for database " + this.tenantName + " finished successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setIsolationLevelHigh(String tenantOsUser, String tenantOsGroup) {
        this.dbIsolationLevelHigh = true;
        this.setTenantOsUser(tenantOsUser);
        this.setTenantOsGroup(tenantOsGroup);
    }

    boolean isIsolationLevelHigh() {
        return this.dbIsolationLevelHigh;
    }

    public String getTenantOsUser() {
        return this.tenantOsUser;
    }

    public void setTenantOsUser(String tenantOsUser) {
        this.tenantOsUser = tenantOsUser;
    }

    public String getTenantOsGroup() {
        return this.tenantOsGroup;
    }

    public void setTenantOsGroup(String tenantOsGroup) {
        this.tenantOsGroup = tenantOsGroup;
    }

    public void rename(JdbcConnection connection, DatabaseSystemUser systemDatabaseUser, Sid tenantSidNew) {
        this.setSystemDatabaseData(connection, systemDatabaseUser);
        if (this.isActive(connection, systemDatabaseUser)) {
            throw new HdbException("Tenant database " + this.tenantName + " must be offline!");
        }
        connection.executeSQLCommand("RENAME DATABASE " + this.tenantName + " TO " + tenantSidNew.sid);
    }

    public void waitForPKI(JdbcConnection connection, DatabaseSystemUser tenantSystemUser) {
        this.setTenantData(connection, tenantSystemUser);
        connection.waitForPKI();
    }
}

