/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DatabaseTraceFile {
    public Set<String> getTraceEntries(JdbcConnection connection, DatabaseSystemUser systemUser, FileName backupLog, String searchString) {
        HashSet<String> entries = new HashSet<String>();
        ArrayList<String> resultStrings = new ArrayList<String>();
        connection.setConnectUser(systemUser);
        if (connection.isFakeConnection()) {
            for (String fakeLine : connection.executeSQLCommand("Fake")) {
                resultStrings.add(fakeLine);
            }
        } else {
            try {
                PreparedStatement stmt = connection.prepareSQLCommand("SELECT host, file_name, offset, content FROM PUBLIC.M_TRACEFILE_CONTENTS WHERE host = ? AND file_name = ? AND content like '%" + searchString + "%'");
                stmt.setString(1, connection.getDatabase().getMasterHost(connection, systemUser));
                stmt.setString(2, backupLog.toString());
                stmt.execute();
                ResultSet result = stmt.getResultSet();
                while (result.next()) {
                    resultStrings.add(result.getString(4));
                }
            }
            catch (SQLException e) {
                throw new HdbException(e);
            }
        }
        for (String resultString : resultStrings) {
            String[] lines;
            for (String line : lines = resultString.split("\n")) {
                if (!line.contains(searchString)) continue;
                entries.add(line);
            }
        }
        return entries;
    }

    public static enum FileName {
        BACKUP_LOG("backup.log");

        private String fileName;

        private FileName(String fileName) {
            this.fileName = fileName;
        }

        public String toString() {
            return this.fileName;
        }
    }
}

