/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObject;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObjectType;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseView
implements DatabaseCatalogObject {
    private String viewName = null;
    private String schemaName = null;

    public DatabaseView(String tableName) {
        this(null, tableName);
    }

    public DatabaseView(String schemaName, String viewName) {
        this.viewName = viewName;
        this.schemaName = schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public boolean exists(JdbcConnection connection) {
        return this.exists(connection.getConnection());
    }

    @Override
    public boolean exists(Connection connection) {
        boolean exists = false;
        PreparedStatement stmnt = null;
        ResultSet result = null;
        try {
            if (this.schemaName != null) {
                stmnt = connection.prepareStatement("SELECT COUNT(VIEW_NAME) FROM " + this.getMonitoringView().getFullNameQuoted() + " WHERE VIEW_NAME = ? AND SCHEMA_NAME = ?");
                stmnt.setString(1, this.viewName);
                stmnt.setString(2, this.schemaName);
            } else {
                stmnt = connection.prepareStatement("SELECT COUNT(VIEW_NAME) FROM " + this.getMonitoringView().getFullNameQuoted() + "" + " WHERE VIEW_NAME = ?");
                stmnt.setString(1, this.viewName);
            }
            result = stmnt.executeQuery();
            while (result.next()) {
                int count = result.getInt(1);
                if (count <= 0) continue;
                exists = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(result);
                IOUtils.closeQuietly(stmnt);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(result);
        IOUtils.closeQuietly(stmnt);
        return exists;
    }

    @Override
    public String getFullName() {
        String fullName = "";
        fullName = this.schemaName != null ? this.schemaName + "." + this.viewName : this.viewName;
        return fullName;
    }

    @Override
    public String getFullNameQuoted() {
        String fullName = "";
        fullName = this.schemaName != null ? "\"" + this.schemaName + "\".\"" + this.viewName + "\"" : "\"" + this.viewName + "\"";
        return fullName;
    }

    @Override
    public DatabaseCatalogObject getMonitoringView() {
        DatabaseView table = new DatabaseView("VIEWS");
        table.setSchemaName("PUBLIC");
        return table;
    }

    @Override
    public DatabaseCatalogObjectType getType() {
        return DatabaseCatalogObjectType.VIEW;
    }
}

