/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabasePort;
import com.sap.hdb.sl.lib.instance.DatabaseVolume;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.LiveCache;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class DatabaseVolumeList
extends ArrayList<DatabaseVolume> {
    private static final long serialVersionUID = 3435286965878020870L;
    private JdbcConnection connection = null;

    protected DatabaseVolumeList(JdbcConnection connection, DatabaseSystemUser systemUser) {
        this.connection = connection;
        this.connection.setConnectUser(systemUser);
        PreparedStatement stmt = connection.prepareSQLCommand("SELECT HOST, PORT, SERVICE_NAME, SUBPATH, LIVECACHE_STORE, REMOVE_STATUS FROM M_VOLUMES");
        try {
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Hostname hostName = new Hostname(result.getString("HOST"));
                DatabasePort port = new DatabasePort(result.getString("PORT"));
                Instance.ServiceName serviceName = Instance.ServiceName.valueOf(result.getString("SERVICE_NAME").toUpperCase(Locale.ENGLISH));
                LiveCache.LiveCacheStore liveCacheStore = LiveCache.LiveCacheStore.valueOf(result.getString("LIVECACHE_STORE"));
                DatabaseVolume volume = new DatabaseVolume(hostName, port, serviceName, liveCacheStore);
                this.add(volume);
            }
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    private void readObject(ObjectInputStream in) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

