/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DatabaseXmlParameter {
    public static final Map<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> DEFAULT_PARAMETER_VALUES = DatabaseXmlParameter.loadDefaultParameterValues();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private DatabaseConfiguration.ConfigFileName configurationFileName;
    private String sectionName;
    private String parameterName;
    private String parameterValue;
    private boolean persistent;

    private static Map<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> loadDefaultParameterValues() {
        EnumMap defaultParameterValues = new EnumMap(DatabaseConfiguration.ConfigFileName.class);
        HashMap<String, String> parameterValueMap = new HashMap<String, String>();
        parameterValueMap.put("client_distribution_mode", "statement");
        HashMap<String, HashMap<String, String>> sectionMap = new HashMap<String, HashMap<String, String>>();
        sectionMap.put("distribution", parameterValueMap);
        defaultParameterValues.put(DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI, sectionMap);
        parameterValueMap = new HashMap();
        parameterValueMap.put("method", "2");
        parameterValueMap.put("prefix", "/");
        parameterValueMap.put("bw_schema", null);
        sectionMap = new HashMap();
        sectionMap.put("table_placement", parameterValueMap);
        defaultParameterValues.put(DatabaseConfiguration.ConfigFileName.GLOBAL_INI, sectionMap);
        return Collections.unmodifiableMap(defaultParameterValues);
    }

    public static DatabaseXmlParameter fromXml(Node xml) {
        NodeList allChildNodes = xml.getChildNodes();
        ArrayList<Node> childNodes = new ArrayList<Node>();
        for (int i = 0; i < allChildNodes.getLength(); ++i) {
            Node childNode = allChildNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            childNodes.add(childNode);
        }
        if (childNodes.size() < 4 || childNodes.size() > 5) {
            throw new IllegalArgumentException("Wrong parameter format.");
        }
        String configurationFileValue = null;
        String sectionName = null;
        String parameterNameValue = null;
        String parameterValueValue = null;
        String persistent = null;
        for (Node childNode : childNodes) {
            if ("ConfigurationFile".equals(childNode.getNodeName())) {
                if (configurationFileValue != null) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: component 'ConfigurationFile' exists more than once.");
                    throw new HdbException("Invalid XML parameter: component 'ConfigurationFile' exists more than once.");
                }
                configurationFileValue = childNode.getTextContent().trim();
                continue;
            }
            if ("Section".equals(childNode.getNodeName())) {
                if (sectionName != null) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: component 'Section' exists more than once.");
                    throw new HdbException("Invalid XML parameter: component 'Section' exists more than once.");
                }
                sectionName = childNode.getTextContent().trim();
                continue;
            }
            if ("ParameterName".equals(childNode.getNodeName())) {
                if (parameterNameValue != null) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: component 'ParameterName' exists more than once.");
                    throw new HdbException("Invalid XML parameter: component 'ParameterName' exists more than once.");
                }
                parameterNameValue = childNode.getTextContent().trim();
                continue;
            }
            if ("ParameterValue".equals(childNode.getNodeName())) {
                if (parameterValueValue != null) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: component 'ParameterValue' exists more than once.");
                    throw new HdbException("Invalid XML parameter: component 'ParameterValue' exists more than once.");
                }
                parameterValueValue = childNode.getTextContent().trim();
                continue;
            }
            if ("Persistent".equals(childNode.getNodeName())) {
                if (persistent != null) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: component 'Persistent' exists more than once.");
                    throw new HdbException("Invalid XML parameter: component 'Persistent' exists more than once.");
                }
                persistent = childNode.getTextContent().trim();
                continue;
            }
            LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: unknown component '" + childNode.getNodeName() + "'");
            throw new HdbException("Invalid XML parameter: unknown component '" + childNode.getNodeName() + "'");
        }
        if (configurationFileValue == null || sectionName == null || parameterNameValue == null) {
            LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid XML parameter: one of 'ConfigurationFile', 'Section', or 'ParameterName' missing.");
            throw new HdbException("Invalid XML parameter: one of 'ConfigurationFile', 'Section', or 'ParameterName' missing.");
        }
        DatabaseConfiguration.ConfigFileName configFileName = DatabaseConfiguration.ConfigFileName.fromString(configurationFileValue);
        if (configFileName == null) {
            LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Unknown configuration file: " + configurationFileValue);
            throw new HdbException("Unknown configuration file: " + configurationFileValue);
        }
        if (parameterValueValue == null || parameterValueValue.trim().isEmpty()) {
            parameterValueValue = DatabaseXmlParameter.getDefaultValue(configFileName, sectionName, parameterNameValue);
        }
        DatabaseXmlParameter parameter = new DatabaseXmlParameter();
        parameter.setConfigurationFileName(configFileName);
        parameter.setSectionName(sectionName);
        parameter.setParameterName(parameterNameValue);
        parameter.setParameterValue(parameterValueValue);
        parameter.setPersistent(Boolean.parseBoolean(persistent));
        return parameter;
    }

    public static DatabaseXmlParameter fromXml(String xml) {
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
            return DatabaseXmlParameter.fromXml(document.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            throw new HdbException(e);
        }
        catch (SAXException e) {
            throw new HdbException(e);
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
    }

    public static DatabaseXmlParameter fromText(String text) {
        String[] parameterParts = text.split(Pattern.quote("|"));
        if (parameterParts.length < 4) {
            LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Invalid parameter format.");
            throw new IllegalArgumentException("Invalid parameter format.");
        }
        if (parameterParts.length > 4) {
            StringBuilder sb = new StringBuilder();
            for (int i = 3; i < parameterParts.length; ++i) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(parameterParts[i]);
            }
            parameterParts[3] = sb.toString();
        }
        DatabaseConfiguration.ConfigFileName configFileName = DatabaseConfiguration.ConfigFileName.fromString(parameterParts[0]);
        String sectionName = parameterParts[1];
        String parameterName = parameterParts[2];
        String parameterValue = "null".equals(parameterParts[3]) ? null : parameterParts[3];
        DatabaseXmlParameter parameter = new DatabaseXmlParameter();
        parameter.setConfigurationFileName(configFileName);
        parameter.setSectionName(sectionName);
        parameter.setParameterName(parameterName);
        parameter.setParameterValue(parameterValue);
        return parameter;
    }

    private static String getDefaultValue(DatabaseConfiguration.ConfigFileName configurationFile, String section, String parameterName) {
        Map<String, Map<String, String>> sectionMap = DEFAULT_PARAMETER_VALUES.get((Object)configurationFile);
        if (sectionMap == null) {
            return null;
        }
        Map<String, String> parameterMap = sectionMap.get(section);
        if (parameterMap == null) {
            return null;
        }
        return parameterMap.get(parameterName);
    }

    public boolean isDefaultParameter() {
        Map<String, Map<String, String>> sectionMap = DEFAULT_PARAMETER_VALUES.get((Object)this.configurationFileName);
        if (sectionMap == null) {
            return false;
        }
        Map<String, String> parameterMap = sectionMap.get(this.sectionName);
        if (parameterMap == null) {
            return false;
        }
        return parameterMap.containsKey(this.parameterName);
    }

    public DatabaseConfiguration.ConfigFileName getConfigurationFileName() {
        return this.configurationFileName;
    }

    public void setConfigurationFileName(DatabaseConfiguration.ConfigFileName configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public void setParameterValue(String parameterValue) {
        this.parameterValue = parameterValue;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }
}

