/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.io.File;

public class FileParameter
implements CmdClazzParameter {
    private final File file;
    private CmdClazzParameterNameIF cmdClassParameterName;

    public FileParameter(String filePath) {
        this.file = new File(filePath);
        if (!this.file.exists()) {
            LogFactory.writeLogEntry(this.getClass(), "The file '" + this.file + "' does not exist.");
        }
        if (!this.file.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "The file '" + this.file + "' is not a file.");
        }
        if (!this.file.canRead()) {
            LogFactory.writeLogEntry(this.getClass(), "The file '" + this.file + "' is not readable.");
        }
    }

    @Override
    public String getValue() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.cmdClassParameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.cmdClassParameterName = name;
    }
}

