/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public class HdbLcmInstallationComponents
implements InstallationParameter,
CmdClazzParameter {
    private String component = null;
    private CmdClazzParameterNameIF parameterName = null;

    public HdbLcmInstallationComponents(String name) {
        this.validate(name);
        this.component = name.trim();
    }

    public HdbLcmInstallationComponents(CmdClazzParameterMap parameters) {
        this(parameters.get(CmdClazzParameterName.INSTALLATION_COMPONENTS).getValue());
    }

    public String get() {
        return this.component;
    }

    @Override
    public String getValue() {
        return this.component;
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        return HdbInstOption.COMPONENTS;
    }

    public String toString() {
        return this.component;
    }

    private void validate(String installationComponents) {
        if (null == installationComponents || installationComponents.trim().length() == 0) {
            throw new HdbException(installationComponents + " Components must not be null or empty");
        }
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof HdbLcmInstallationComponents) {
            String theirName = o.toString();
            if (this.component.equalsIgnoreCase(theirName)) {
                equals = true;
            } else {
                String theirSubString = theirName;
                String mySubString = this.component;
                if (theirName.contains(".")) {
                    theirSubString = theirName.substring(0, theirName.indexOf("."));
                }
                if (this.component.contains(".")) {
                    mySubString = this.component.substring(0, this.component.indexOf("."));
                }
                if (mySubString.equalsIgnoreCase(theirSubString)) {
                    equals = true;
                }
            }
        } else if (o instanceof String) {
            String theirName = new HdbLcmInstallationComponents((String)o).get();
            if (this.component.equalsIgnoreCase(theirName)) {
                equals = true;
            } else {
                String theirSubString = theirName;
                String mySubString = this.component;
                if (theirName.contains(".")) {
                    theirSubString = theirName.substring(0, theirName.indexOf("."));
                }
                if (this.component.contains(".")) {
                    mySubString = this.component.substring(0, this.component.indexOf("."));
                }
                if (mySubString.equalsIgnoreCase(theirSubString)) {
                    equals = true;
                }
            }
        } else {
            equals = super.equals(o);
        }
        return equals;
    }
}

