/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HdbVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.(([0-9]+)\\.)?([0-9]+)");
    private String versionString = null;
    private int majorVersion;
    private int minorVersion;
    private int revision;
    private int subRevision;
    private long timestampOrChangelist;
    private JdbcConnection connection = null;

    public HdbVersion(String version) {
        this.versionString = version.trim();
        this.validate(this.versionString);
    }

    public HdbVersion(JdbcConnection connection, DatabaseUser connectUser) {
        this.connection = connection;
        this.connection.setConnectUser(connectUser);
        this.get();
    }

    public String get() {
        if (null == this.versionString && null != this.connection) {
            List<String> result = this.connection.executeSQLCommand("SELECT VERSION FROM M_DATABASE");
            if (result.size() != 1) {
                throw new HdbException(result.toString() + "Error during determing of database version!");
            }
            this.versionString = result.get(0);
            this.validate(this.versionString);
        }
        return this.versionString;
    }

    public String toString() {
        return this.get();
    }

    private void validate(String hdbVersion) {
        if (null == hdbVersion || hdbVersion.trim().length() == 0) {
            throw new HdbException(hdbVersion + " HdbVersion must not be null or empty");
        }
        Matcher matcher = VERSION_PATTERN.matcher(hdbVersion);
        if (!matcher.matches()) {
            throw new HdbException(hdbVersion + " HdbVersion must match the pattern " + VERSION_PATTERN.toString());
        }
        this.majorVersion = Integer.parseInt(matcher.group(1));
        this.minorVersion = Integer.parseInt(matcher.group(2));
        this.revision = Integer.parseInt(matcher.group(3));
        String subRevisionString = matcher.group(5);
        this.subRevision = subRevisionString != null ? Integer.parseInt(subRevisionString) : 0;
        this.timestampOrChangelist = Integer.parseInt(matcher.group(6));
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getSubRevision() {
        return this.subRevision;
    }

    public long getTimestampOrChangelist() {
        return this.timestampOrChangelist;
    }
}

