/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public class Hostname
implements InstallationParameter,
CmdClazzParameter {
    private String name = null;
    private CmdClazzParameterNameIF parameterName = null;

    public Hostname(String name) {
        this.validate(name);
        this.name = name.trim();
    }

    public Hostname(CmdClazzParameterMap parameters) {
        this(parameters.get(CmdClazzParameterName.DATABASE_HOSTNAME).getValue());
    }

    public String get() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.name;
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        return HdbInstOption.HOSTNAME;
    }

    public String toString() {
        return this.name;
    }

    private void validate(String hostName) {
        if (null == hostName || hostName.trim().length() == 0) {
            throw new HdbException(hostName + " Hostname must not be null or empty");
        }
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof Hostname) {
            String theirName = o.toString();
            if (this.name.equalsIgnoreCase(theirName)) {
                equals = true;
            } else {
                String theirSubString = theirName;
                String mySubString = this.name;
                if (theirName.contains(".")) {
                    theirSubString = theirName.substring(0, theirName.indexOf("."));
                }
                if (this.name.contains(".")) {
                    mySubString = this.name.substring(0, this.name.indexOf("."));
                }
                if (mySubString.equalsIgnoreCase(theirSubString)) {
                    equals = true;
                }
            }
        } else if (o instanceof String) {
            String theirName = new Hostname((String)o).get();
            if (this.name.equalsIgnoreCase(theirName)) {
                equals = true;
            } else {
                String theirSubString = theirName;
                String mySubString = this.name;
                if (theirName.contains(".")) {
                    theirSubString = theirName.substring(0, theirName.indexOf("."));
                }
                if (this.name.contains(".")) {
                    mySubString = this.name.substring(0, this.name.indexOf("."));
                }
                if (mySubString.equalsIgnoreCase(theirSubString)) {
                    equals = true;
                }
            }
        } else {
            equals = super.equals(o);
        }
        return equals;
    }
}

