/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.io.File;
import java.util.Locale;

public class InstallationDrive
implements InstallationParameter,
CmdClazzParameter {
    private String drive = null;
    private CmdClazzParameterNameIF parameterName = null;

    public InstallationDrive(File drive) {
        this.drive = this.prepareDrive(drive.getAbsolutePath());
    }

    public InstallationDrive(String drive) {
        this(new File(drive));
    }

    @Override
    public String getValue() {
        return this.drive;
    }

    public String toString() {
        return this.drive;
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        return HdbInstOption.DRIVE;
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.drive == null ? 0 : this.drive.hashCode());
        return result;
    }

    public boolean equals(Object installationDrive) {
        boolean equals = false;
        if (installationDrive instanceof InstallationDrive) {
            String thisPath = this.drive;
            String theirPath = installationDrive.toString();
            if (thisPath.equalsIgnoreCase(theirPath)) {
                equals = true;
            }
        } else {
            super.equals(installationDrive);
        }
        return equals;
    }

    private String prepareDrive(String driveParam) {
        String preparedDrive = driveParam;
        if (preparedDrive.startsWith("/") || preparedDrive.startsWith("\\") || !preparedDrive.contains(":")) {
            throw new HdbException(preparedDrive + " not a valid drive name!");
        }
        preparedDrive = preparedDrive.substring(0, 2).toUpperCase(Locale.ENGLISH);
        return preparedDrive;
    }
}

