/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.instance.DatabasePort;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.user.User;

public class Instance {
    private Type type = null;
    private InstanceNumber number = null;
    private HdbVersion version = null;
    private Hostname hostname = null;
    private User connectUser = null;
    private DatabasePort port = null;

    protected Instance(Type type) {
        this.type = type;
        this.hostname = new Hostname("localhost");
    }

    protected Instance(Type type, InstanceNumber number) {
        this.type = type;
        this.number = number;
        this.hostname = new Hostname("localhost");
    }

    protected Instance(Type type, InstanceNumber instanceNumber, HdbVersion version, Hostname host) {
        this(type, instanceNumber);
        this.version = version;
        this.hostname = host;
    }

    protected Instance(Type type, InstanceNumber number, Hostname host) {
        this.type = type;
        this.number = number;
        this.hostname = host;
    }

    public Instance(Type type, DatabasePort port) {
        this.type = type;
        this.port = port;
        this.hostname = new Hostname("localhost");
    }

    public Type getType() {
        return this.type;
    }

    public InstanceNumber getNumber() {
        return this.number;
    }

    public HdbVersion getVersion() {
        return this.version;
    }

    public Hostname getHostname() {
        return this.hostname;
    }

    public User getConnectUser() {
        return this.connectUser;
    }

    public void setHostname(Hostname hostname) {
        this.hostname = hostname;
    }

    public void setConnectUser(User user) {
        this.connectUser = user;
    }

    public static enum ServiceName {
        NAMESERVER,
        INDEXSERVER,
        STATISTICSSERVER,
        XSENGINE,
        SCRIPTSERVER,
        DPSERVER,
        DOCSTORE,
        ESSERVER;

    }

    public static enum Type {
        ASCS,
        D,
        DVEBMGS,
        ERS,
        G,
        HDB,
        J,
        JC,
        SCS,
        SMDA,
        TRX,
        W;

    }
}

