/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.LiveCache;
import com.sap.hdb.sl.lib.instance.Port;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class InstanceFactory {
    private InstanceFactory() {
    }

    public static LiveCache getLiveCacheInstance(CmdClazzParameterMap parameters) {
        Database database = InstanceFactory.getDatabaseInstance(parameters);
        LiveCache liveCache = new LiveCache(database.getNumber(), database.getHostname());
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SID)) {
            Sid sid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
            liveCache.setSid(sid);
        }
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_MODE)) {
            liveCache.setDatabaseMode(Database.DatabaseMode.valueOf(parameters.get(CmdClazzParameterName.DATABASE_MODE).getValue()));
        }
        return liveCache;
    }

    public static LiveCache getLiveCacheInstance(InstanceNumber instanceNumber) {
        Database database = InstanceFactory.getDatabaseInstance(instanceNumber);
        LiveCache liveCache = new LiveCache(database.getNumber());
        return liveCache;
    }

    public static Instance getInstance(CmdClazzParameterMap parameters) {
        Hostname hostname = new Hostname(parameters);
        InstanceNumber instanceNumber = new InstanceNumber(parameters);
        Instance instance = new Instance(Instance.Type.HDB, instanceNumber);
        instance.setHostname(hostname);
        return instance;
    }

    public static Database getDatabaseInstance(CmdClazzParameterMap parameters) {
        Hostname hostname = new Hostname(parameters);
        Database database = null;
        if (parameters.containsKey(CmdClazzParameterName.INSTANCE_NUMBER)) {
            database = new Database(new InstanceNumber(parameters));
            if (parameters.containsKey(CmdClazzParameterName.DATABASE_SID)) {
                Sid sid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
                database.setSid(sid);
            }
            if (parameters.containsKey(CmdClazzParameterName.PORT)) {
                database.setPort(parameters.get(CmdClazzParameterName.PORT).getValue());
            }
        } else if (parameters.containsKey(CmdClazzParameterName.PORT)) {
            database = new Database(new Port(parameters.get(CmdClazzParameterName.PORT).getValue()));
        } else {
            throw new HdbException("Insufficient parameters to create Database object. Either database port or instance number and database SID are required;");
        }
        database.setHostname(hostname);
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_MODE)) {
            database.setDatabaseMode(Database.DatabaseMode.valueOf(parameters.get(CmdClazzParameterName.DATABASE_MODE).getValue()));
        }
        if (parameters.containsKey(CmdClazzParameterName.SYSTEMDB_PORT)) {
            database.setSystemDBPort(parameters.get(CmdClazzParameterName.SYSTEMDB_PORT).getValue());
        }
        if (parameters.containsKey(CmdClazzParameterName.ENCRYPT)) {
            if (database.setEncrypt(parameters.get(CmdClazzParameterName.ENCRYPT).getValue())) {
                if (parameters.containsKey(CmdClazzParameterName.ENCRYPT_PROPS)) {
                    database.setEncryptProperties(parameters.get(CmdClazzParameterName.ENCRYPT_PROPS).getValue());
                }
                if (parameters.containsKey(CmdClazzParameterName.ENCRYPT_CHECK)) {
                    database.setForceEncrypt(parameters.get(CmdClazzParameterName.ENCRYPT_CHECK).getValue());
                }
            }
        } else if (parameters.containsKey(CmdClazzParameterName.ENCRYPT_PROPS)) {
            database.setEncryptProperties(parameters.get(CmdClazzParameterName.ENCRYPT_PROPS).getValue());
        }
        return database;
    }

    public static Database getDatabaseInstance(InstanceNumber instanceNumber) {
        return new Database(instanceNumber);
    }

    public static Instance getInstance(Instance.Type instanceType, InstanceNumber instanceNumber) {
        return new Instance(instanceType, instanceNumber);
    }

    public static Instance getInstance(Instance.Type instanceType, InstanceNumber instanceNumber, HdbVersion hdbVersion, Hostname hostname) {
        return new Instance(instanceType, instanceNumber, hdbVersion, hostname);
    }

    public static DatabaseTenant getDatabaseTenant(Sid sid, JdbcConnection connection) {
        return new DatabaseTenant(sid, connection);
    }

    public static Database getSystemDatabaseInstance(CmdClazzParameterMap parameters) {
        Hostname hostname = new Hostname(parameters);
        InstanceNumber instanceNumber = new InstanceNumber(parameters);
        Database database = new Database(instanceNumber);
        database.setDatabaseMode(Database.DatabaseMode.MULTIPLE);
        if (parameters.containsKey(CmdClazzParameterName.ENCRYPT) && database.setEncrypt(parameters.get(CmdClazzParameterName.ENCRYPT).getValue()) && parameters.containsKey(CmdClazzParameterName.ENCRYPT_PROPS)) {
            database.setEncryptProperties(parameters.get(CmdClazzParameterName.ENCRYPT_PROPS).getValue());
        }
        database.setHostname(hostname);
        Sid sid = new Sid("SYSTEMDB");
        database.setSid(sid);
        return database;
    }

    public static Database getIfExistsDatabaseOrTenantOrSystemDB(CmdClazzParameterMap parameters) {
        JdbcDriver jdbcDriver = new JdbcDriver(parameters);
        Database database = InstanceFactory.getDatabaseInstance(parameters);
        JdbcConnection connection = JdbcConnectionFactory.getInstance(jdbcDriver, database);
        if (connection.isMultiDB() && !connection.doesTenantExist()) {
            connection.setConnectUser(SystemDatabaseSystemUserFactory.getUser(parameters));
            database = InstanceFactory.getSystemDatabaseInstance(parameters);
        }
        return database;
    }
}

