/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.InstallationPath;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.Sid;
import java.util.HashMap;

public class InstanceGroup {
    private InstallationPath installationPath = null;
    private Sid sid = null;
    private Description description = null;
    private HashMap<Instance.Type, Instance> instances = new HashMap();

    public InstanceGroup(Sid sid, InstallationPath installationPath, Description description) {
        this.sid = sid;
        this.installationPath = installationPath;
        this.description = description;
    }

    public Sid getSid() {
        return this.sid;
    }

    public Description getDescription() {
        return this.description;
    }

    public void addInstance(Instance instance) {
        this.instances.put(instance.getType(), instance);
    }

    public InstallationPath getInstallationPath() {
        return this.installationPath;
    }

    public boolean containsInstance(Instance.Type type) {
        boolean exists = false;
        if (this.instances.containsKey((Object)type)) {
            exists = true;
        }
        return exists;
    }

    public Instance getInstance(Instance.Type type) {
        Instance instance = null;
        if (!this.instances.containsKey((Object)type)) {
            throw new HdbException(type.toString() + " No such type in Group " + this.sid + " in path " + this.installationPath);
        }
        instance = this.instances.get((Object)type);
        return instance;
    }

    public static enum Description {
        OTHERS,
        NEWDB_ALONE,
        NEWDB_AND_OTHERS,
        HDB_ALONE,
        HDB_AND_OTHERS;

    }
}

