/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public class InstanceNumber
implements InstallationParameter,
CmdClazzParameter {
    private CmdClazzParameterNameIF parameterName = null;
    private String instanceNumber = null;

    public InstanceNumber(String numberString) {
        if (numberString == null) {
            throw new HdbException("Instance number is null");
        }
        try {
            this.validateInteger(Integer.parseInt(numberString.trim()));
        }
        catch (NumberFormatException e) {
            throw new HdbException(numberString + " not a valid instance number!");
        }
        this.instanceNumber = numberString.trim();
    }

    public InstanceNumber(int instanceNumber) {
        this.validateInteger(instanceNumber);
        if (instanceNumber > -1 && instanceNumber < 10) {
            this.instanceNumber = "0" + String.valueOf(instanceNumber);
        } else if (instanceNumber < 100) {
            this.instanceNumber = String.valueOf(instanceNumber);
        }
    }

    public InstanceNumber(CmdClazzParameterMap parameters) {
        this(parameters.get(CmdClazzParameterName.INSTANCE_NUMBER).getValue());
    }

    public String get() {
        return this.instanceNumber;
    }

    public String toString() {
        return this.instanceNumber;
    }

    @Override
    public String getValue() {
        return this.instanceNumber;
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        return HdbInstOption.NUMBER;
    }

    private void validateInteger(int instanceNumberToValidate) {
        if (instanceNumberToValidate < 0) {
            throw new HdbException(instanceNumberToValidate + " instance number is negative!");
        }
        if (instanceNumberToValidate > 99) {
            throw new HdbException(instanceNumberToValidate + " instance number is too high!");
        }
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InstanceNumber)) {
            return false;
        }
        InstanceNumber in = (InstanceNumber)o;
        return this.instanceNumber == null ? in.instanceNumber == null : this.instanceNumber.equals(in.instanceNumber);
    }

    public boolean equals(Integer i) {
        if (i == null) {
            return false;
        }
        InstanceNumber in = new InstanceNumber(i);
        return this.instanceNumber == null ? in.instanceNumber == null : this.instanceNumber.equals(in.instanceNumber);
    }

    public boolean equals(String s) {
        if (s == null) {
            return false;
        }
        InstanceNumber in = new InstanceNumber(s);
        return this.instanceNumber == null ? in.instanceNumber == null : this.instanceNumber.equals(in.instanceNumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceNumber == null ? 0 : this.instanceNumber.hashCode());
        return result;
    }
}

