/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import java.util.List;

public class LcaAlertsSchema {
    private String schemaName = "LCAALERTS";

    public boolean schemaExists(JdbcConnection connection, DatabaseUser sqlUser) {
        String statement = "SELECT SCHEMA_NAME FROM SCHEMAS WHERE SCHEMA_NAME = 'LCAALERTS'";
        List<String> result = this.executeStatement(statement, connection, sqlUser);
        return result.size() == 1;
    }

    public boolean createSchema(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUserName sqlUser) {
        if (!this.schemaExists(connection, systemUser)) {
            connection.setConnectUser(systemUser);
            String statement = "CREATE SCHEMA LCAALERTS";
            connection.executeSQLCommandNoReslt(statement);
        }
        return true;
    }

    public boolean grantPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUserName sqlUser) {
        String[] lcaAlertsGrants = new String[]{"GRANT CREATE ANY ON SCHEMA LCAALERTS TO " + sqlUser.get(), "GRANT DROP ON SCHEMA LCAALERTS TO " + sqlUser.get(), "GRANT SELECT ON SCHEMA LCAALERTS TO " + sqlUser.get(), "GRANT INSERT ON SCHEMA LCAALERTS TO " + sqlUser.get(), "GRANT DELETE ON SCHEMA LCAALERTS TO " + sqlUser.get()};
        try {
            this.executeStatements(lcaAlertsGrants, connection, systemUser);
        }
        catch (HdbException e) {
            String statement;
            List<String> results;
            if (e.testInsufficientPrivilege() && (results = this.executeStatement(statement = "SELECT SCHEMA_OWNER FROM SCHEMAS WHERE SCHEMA_NAME = 'LCAALERTS'", connection, systemUser)).get(0).equalsIgnoreCase(sqlUser.get())) {
                return true;
            }
            throw e;
        }
        return true;
    }

    private void executeStatements(String[] statements, JdbcConnection connection, DatabaseUser systemUser) {
        for (String statement : statements) {
            this.executeStatement(statement, connection, systemUser);
        }
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser sqlUser) {
        connection.setConnectUser(sqlUser);
        return connection.executeSQLCommand(statement);
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

