/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import java.util.regex.Pattern;

public enum Privilege {
    ALL_PRIVILEGES(false, true, true, false, false),
    ALTER(true, true, false, false, true),
    CREATE_ANY(true, false, false, false, false),
    DEBUG(true, false, true, false, true),
    DELETE(true, true, true, false, false),
    DROP(true, true, true, true, true),
    EXECUTE(true, false, false, false, true),
    INDEX(true, true, false, false, false),
    INSERT(true, true, true, false, false),
    REFERENCES(true, true, false, false, false),
    SELECT(true, true, true, true, false),
    TRIGGER(true, true, false, false, false),
    UPDATE(true, true, true, false, false);

    private final boolean grantableOnSchema;
    private final boolean grantableOnTable;
    private final boolean grantableOnView;
    private final boolean grantableOnSequence;
    private final boolean grantableOnProcedure;

    private Privilege(boolean grantableOnSchema, boolean grantableOnTable, boolean grantableOnView, boolean grantableOnSequence, boolean grantableOnProcedure) {
        this.grantableOnProcedure = grantableOnProcedure;
        this.grantableOnSchema = grantableOnSchema;
        this.grantableOnSequence = grantableOnSequence;
        this.grantableOnTable = grantableOnTable;
        this.grantableOnView = grantableOnView;
    }

    public boolean isGrantableOnSchema() {
        return this.grantableOnSchema;
    }

    public boolean isGrantableOnTable() {
        return this.grantableOnTable;
    }

    public boolean isGrantableOnView() {
        return this.grantableOnView;
    }

    public boolean isGrantableOnSequence() {
        return this.grantableOnSequence;
    }

    public boolean isGrantableOnProcedure() {
        return this.grantableOnProcedure;
    }

    public String toString() {
        return this.name().replaceAll(Pattern.quote("_"), " ");
    }
}

