/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Product {
    private static final Pattern SR_PATTERN = Pattern.compile("([0-9]+)SR([0-9]+)");
    private static final Pattern ONPREMISE_PATTERN = Pattern.compile("ONPREM([0-9]+)");
    private String name;
    private String versionString;
    private EhP ehpVersion;
    private int version = -1;
    private int serviceRelease = 0;
    private boolean onPremiseVersion = false;

    public Product(String name, String versionString) {
        this.name = name;
        this.versionString = versionString;
        if (EhP.isEhP(versionString)) {
            this.ehpVersion = new EhP(versionString);
        } else if (versionString.matches("[0-9]+")) {
            this.version = Integer.parseInt(versionString);
        } else if (versionString.matches("[0-9]+HANA")) {
            this.version = Integer.parseInt(versionString.substring(0, versionString.length() - 4));
        } else {
            Matcher srPatternMatcher = SR_PATTERN.matcher(versionString);
            if (srPatternMatcher.matches()) {
                this.version = Integer.parseInt(srPatternMatcher.group(1));
                this.serviceRelease = Integer.parseInt(srPatternMatcher.group(2));
            } else {
                Matcher onPremisePatternMatcher = ONPREMISE_PATTERN.matcher(versionString);
                if (onPremisePatternMatcher.matches()) {
                    this.version = Integer.parseInt(onPremisePatternMatcher.group(1));
                    this.onPremiseVersion = true;
                } else {
                    LogFactory.writeLogEntry(this.getClass(), "Unsupported product version format: " + versionString + ".");
                    this.version = -1;
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public boolean isEhP() {
        return this.ehpVersion != null;
    }

    public boolean isOnHana() {
        return this.ehpVersion != null && this.ehpVersion.isOnHana();
    }

    public EhP getEhpVersion() {
        return this.ehpVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public int getServiceRelease() {
        return this.serviceRelease;
    }

    public boolean isOnPremiseVersion() {
        return this.onPremiseVersion;
    }

    public List<String> getAuthoringSchemas() {
        ArrayList<String> schemas = new ArrayList<String>();
        if ("ERP".equalsIgnoreCase(this.name)) {
            if (this.isEhP() && (this.ehpVersion.getVersion() == 6 && this.ehpVersion.isOnHana() || this.ehpVersion.getVersion() > 6) || this.version >= 740 || this.version >= 74 && this.version < 100) {
                schemas.add("ABAP");
                schemas.add("SAP_ECC");
            }
        } else if ("SCM".equalsIgnoreCase(this.name)) {
            if (this.isEhP() && (this.ehpVersion.getVersion() == 2 && this.ehpVersion.isOnHana() || this.ehpVersion.getVersion() > 2) || this.version >= 740 || this.version >= 74 && this.version < 100) {
                schemas.add("ABAP");
                schemas.add("SAP_SCM");
            }
        } else if ("CRM".equalsIgnoreCase(this.name)) {
            if (this.isEhP() && (this.ehpVersion.getVersion() == 2 && this.ehpVersion.isOnHana() || this.ehpVersion.getVersion() > 2) || this.version >= 740 || this.version >= 74 && this.version < 100) {
                schemas.add("ABAP");
                schemas.add("SAP_CRM");
            }
        } else if ("S4HANA".equalsIgnoreCase(this.name)) {
            schemas.add("ABAP");
            schemas.add("SAP_ECC");
        } else if (this.isEhP() && this.ehpVersion.isOnHana() || this.version >= 740 || this.version >= 74 && this.version < 100) {
            schemas.add("ABAP");
        }
        return schemas;
    }

    public static class EhP {
        private static final Pattern EHP_PATTERN = Pattern.compile("(EhP)([0-9]+)((oH)|(SR([0-9]+)))?");
        private int version;
        private boolean onHana;
        private int serviceRelease = 0;

        public EhP(String version) {
            Matcher matcher = EHP_PATTERN.matcher(version);
            if (matcher.matches()) {
                this.version = Integer.parseInt(matcher.group(2));
                this.onHana = matcher.group(4) != null;
                this.serviceRelease = matcher.group(6) == null ? 0 : Integer.parseInt(matcher.group(6));
            }
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isOnHana() {
            return this.onHana;
        }

        public int getServiceRelease() {
            return this.serviceRelease;
        }

        public static boolean isEhP(String version) {
            Matcher matcher = EHP_PATTERN.matcher(version);
            return matcher.matches();
        }
    }
}

