/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class SapLicense
implements CmdClazzParameter {
    private static final String LICENSE_START_TOKEN = "----- Begin SAP License -----";
    private Sid sapSystem;
    private String hardwareKey;
    private String instNo;
    private Date begin;
    private Date expiration;
    private String lkey;
    private String swProductName;
    private String swProductLimit;
    private String systemNr;
    private String license;
    private CmdClazzParameterNameIF parameterName;

    public SapLicense() {
    }

    public SapLicense(String licenseFilePath) {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(new File(licenseFilePath)));
            SapLicense.fromReader(fileReader, this);
        }
        catch (FileNotFoundException e) {
            LogFactory.writeLogEntry(SapLicense.class, e.getMessage());
            throw new HdbException(e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public SapLicense(CmdClazzParameterMap parameters) {
        this(parameters.get(CmdClazzParameterName.SAP_LICENSE_FILE).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SapLicense fromString(String licenseString) {
        BufferedReader stringReader = null;
        try {
            stringReader = new BufferedReader(new StringReader(licenseString));
            SapLicense sapLicense = SapLicense.fromReader(stringReader);
            return sapLicense;
        }
        finally {
            if (stringReader != null) {
                try {
                    stringReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static SapLicense fromFile(File licenseFile) throws HdbException {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(licenseFile));
            SapLicense sapLicense = SapLicense.fromReader(fileReader);
            return sapLicense;
        }
        catch (FileNotFoundException e) {
            LogFactory.writeLogEntry(SapLicense.class, e.getMessage());
            throw new HdbException(e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static SapLicense fromReader(BufferedReader r, SapLicense license) {
        String expirationDate;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Properties licenseProperties = new Properties();
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
                if (line.trim().isEmpty()) continue;
                int propertyDelimiterPosition = line.indexOf(61);
                if (propertyDelimiterPosition == -1) {
                    licenseProperties.setProperty(line, "");
                    continue;
                }
                licenseProperties.setProperty(line.substring(0, propertyDelimiterPosition), line.substring(propertyDelimiterPosition + 1));
            }
        }
        catch (IOException e) {
            LogFactory.writeLogEntry(SapLicense.class, "Error reading license file: " + e.getMessage());
            throw new HdbException(e);
        }
        if (licenseProperties.getProperty(LICENSE_START_TOKEN) == null) {
            throw new IllegalArgumentException("Invalid SAP license. Expected '----- Begin SAP License -----' as first line.");
        }
        String beginDate = licenseProperties.getProperty("BEGIN");
        if (beginDate != null) {
            if (beginDate.matches("[0-9]{8}")) {
                try {
                    license.setBegin(sdf.parse(beginDate));
                }
                catch (ParseException e) {
                    LogFactory.writeLogEntry(SapLicense.class, "Invalid begin date: " + beginDate);
                }
            } else {
                LogFactory.writeLogEntry(SapLicense.class, "Invalid begin date: " + beginDate);
            }
        }
        if ((expirationDate = licenseProperties.getProperty("EXPIRATION")) != null) {
            if (expirationDate.matches("[0-9]{8}")) {
                try {
                    license.setExpiration(sdf.parse(expirationDate));
                }
                catch (ParseException e) {
                    LogFactory.writeLogEntry(SapLicense.class, "Invalid expiration date: " + expirationDate);
                }
            } else {
                LogFactory.writeLogEntry(SapLicense.class, "Invalid expiration date: " + beginDate);
            }
        }
        license.setHardwareKey(licenseProperties.getProperty("HARDWARE-KEY"));
        license.setInstNo(licenseProperties.getProperty("INSTNO"));
        license.setLkey(licenseProperties.getProperty("LKEY"));
        license.setSapSystem(new Sid(licenseProperties.getProperty("SAPSYSTEM")));
        license.setSwProductLimit(licenseProperties.getProperty("SWPRODUCTLIMIT"));
        license.setSwProductName(licenseProperties.getProperty("SWPRODUCTNAME"));
        license.setSystemNr(licenseProperties.getProperty("SYSTEM-NR"));
        license.license = sb.toString();
        return license;
    }

    private static SapLicense fromReader(BufferedReader r) {
        SapLicense license = new SapLicense();
        return SapLicense.fromReader(r, license);
    }

    public Sid getSapSystem() {
        return this.sapSystem;
    }

    public void setSapSystem(Sid sapSystem) {
        this.sapSystem = sapSystem;
    }

    public String getHardwareKey() {
        return this.hardwareKey;
    }

    public void setHardwareKey(String hardwareKey) {
        this.hardwareKey = hardwareKey;
    }

    public String getInstNo() {
        return this.instNo;
    }

    public void setInstNo(String instNo) {
        this.instNo = instNo;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public String getLkey() {
        return this.lkey;
    }

    public void setLkey(String lkey) {
        this.lkey = lkey;
    }

    public String getSwProductName() {
        return this.swProductName;
    }

    public void setSwProductName(String swProductName) {
        this.swProductName = swProductName;
    }

    public String getSwProductLimit() {
        return this.swProductLimit;
    }

    public void setSwProductLimit(String swProductLimit) {
        this.swProductLimit = swProductLimit;
    }

    public String getSystemNr() {
        return this.systemNr;
    }

    public void setSystemNr(String systemNr) {
        this.systemNr = systemNr;
    }

    public void setHanaLicense(JdbcConnection connection, DatabaseSystemUser systemUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommandNoReslt("SET SYSTEM LICENSE '" + this.toString() + "'");
    }

    public String toString() {
        return this.license;
    }

    @Override
    public String getValue() {
        return this.license;
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }
}

