/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SchemaMapping {
    public static final String SCHEMA_MAPPING_TABLE = "_SYS_BI.M_SCHEMA_MAPPING";
    private JdbcConnection connection = null;

    public SchemaMapping(JdbcConnection connection, DatabaseSystemUser systemUser) {
        this.connection = connection;
        this.connection.setConnectUser(systemUser);
    }

    public boolean exists(String authoringSchema) {
        boolean exists = false;
        Map<String, DatabaseSqlUser> allMappings = this.getAllMappingsFromDatabase();
        if (allMappings.containsKey(authoringSchema)) {
            exists = true;
        }
        return exists;
    }

    public void createNewMapping(String authoringSchema, DatabaseSqlUser sqlUser) {
        PreparedStatement stmt = this.connection.prepareSQLCommand("INSERT INTO _SYS_BI.M_SCHEMA_MAPPING VALUES(?, ?)");
        try {
            stmt.setString(1, authoringSchema.toString());
            stmt.setString(2, sqlUser.getName().get());
            this.connection.executeSQLCommandNoReslt(stmt);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
    }

    public void deleteMapping(String authoringSchema, DatabaseSqlUser sqlUser) {
        PreparedStatement stmt = this.connection.prepareSQLCommand("DELETE FROM _SYS_BI.M_SCHEMA_MAPPING WHERE AUTHORING_SCHEMA = ? AND PHYSICAL_SCHEMA = ?");
        try {
            stmt.setString(1, authoringSchema.toString());
            stmt.setString(2, sqlUser.getName().get());
            this.connection.executeSQLCommandNoReslt(stmt);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
    }

    public boolean exists(String authoringSchema, DatabaseSqlUser sqlUser) {
        String theirName;
        DatabaseSqlUser user;
        String name;
        boolean exists = false;
        Map<String, DatabaseSqlUser> allMappings = this.getAllMappingsFromDatabase();
        if (allMappings.containsKey(authoringSchema) && (name = (user = allMappings.get(authoringSchema)).getName().get()).equals(theirName = sqlUser.getName().get())) {
            exists = true;
        }
        return exists;
    }

    public Map<String, DatabaseSqlUser> getMappingsForUserFromDatabase(DatabaseSqlUser sqlUser) {
        HashMap<String, DatabaseSqlUser> userMappings = new HashMap<String, DatabaseSqlUser>();
        PreparedStatement stmt = this.connection.prepareSQLCommand("SELECT AUTHORING_SCHEMA, PHYSICAL_SCHEMA FROM _SYS_BI.M_SCHEMA_MAPPING WHERE PHYSICAL_SCHEMA='" + sqlUser.getName().get() + "'");
        try {
            stmt.execute();
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                do {
                    String authoringSchemaString = resultSet.getString(1);
                    DatabaseSqlUser user = DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName(resultSet.getString(2)));
                    userMappings.put(authoringSchemaString, user);
                } while (resultSet.next());
            }
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
        return userMappings;
    }

    public Map<String, DatabaseSqlUser> getAllMappingsFromDatabase() {
        HashMap<String, DatabaseSqlUser> allKnownMappings = new HashMap<String, DatabaseSqlUser>();
        PreparedStatement stmt = this.connection.prepareSQLCommand("SELECT AUTHORING_SCHEMA, PHYSICAL_SCHEMA FROM _SYS_BI.M_SCHEMA_MAPPING");
        try {
            stmt.execute();
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet.next()) {
                do {
                    String authoringSchemaString = resultSet.getString(1);
                    DatabaseSqlUser user = DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName(resultSet.getString(2)));
                    allKnownMappings.put(authoringSchemaString, user);
                } while (resultSet.next());
            }
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {}
        }
        return allKnownMappings;
    }
}

