/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public class SchemaName
implements CmdClazzParameter {
    private String schemaName;
    private CmdClazzParameterNameIF parameterName;
    private OsToolBox osToolBox = OsToolboxFactory.getToolbox();
    private int defaultMinLenght = 5;

    public SchemaName(String schema) {
        this.schemaName = schema;
    }

    public boolean isValid() {
        return this.isValid(this.defaultMinLenght);
    }

    public boolean isValid(int minimumLength) {
        if (this.schemaName == null || this.schemaName.isEmpty()) {
            return false;
        }
        if (!this.schemaName.matches("[A-Z0-9]{" + minimumLength + ",30}")) {
            return false;
        }
        if (this.schemaName.startsWith("_") || this.schemaName.equalsIgnoreCase("SYS") || this.schemaName.equalsIgnoreCase("SYSTEM")) {
            return false;
        }
        if (this.schemaName.length() > 30) {
            return false;
        }
        if (this.schemaName.length() < minimumLength) {
            return false;
        }
        if (Sid.RESERVED_SIDS.contains(this.schemaName)) {
            return false;
        }
        if (this.osToolBox.onWindows() && Sid.RESERVED_SIDS_WINDOWS.contains(this.schemaName)) {
            return false;
        }
        return !Sid.RESERVED_KEYWORDS.contains(this.schemaName);
    }

    @Override
    public String getValue() {
        return this.schemaName;
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }

    public String toString() {
        return this.schemaName;
    }
}

