/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Result;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.HdbUninstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.UninstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public class Sid
implements InstallationParameter,
CmdClazzParameter,
UninstallationParameter {
    public static final Set<String> RESERVED_SIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ADD", "ALL", "AND", "ANY", "ASC", "COM", "DBA", "END", "EPS", "FOR", "GID", "IBM", "INT", "KEY", "LOG", "MON", "NIX", "NOT", "OFF", "OMS", "RAW", "ROW", "SAP", "SET", "SGA", "SHG", "SID", "SQL", "SYS", "TMP", "UID", "USR", "VAR")));
    public static final Set<String> RESERVED_SIDS_WINDOWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9")));
    public static final Set<String> RESERVED_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AND", "ALL", "END", "FOR", "OUT", "SET", "SQL", "TOP")));
    protected String sid = null;
    private CmdClazzParameterNameIF parameterName = null;

    public Sid(CmdClazzParameterMap parameters) {
        this(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
    }

    public Sid(String name) {
        this(name, false);
    }

    public Sid(String name, boolean check) {
        if (name == null || name.isEmpty()) {
            this.sid = "";
        } else {
            Result result = this.validate(name);
            if (!check || result.isValid()) {
                this.sid = name.toUpperCase(Locale.ENGLISH);
            } else {
                throw new HdbException(result.getMessage());
            }
        }
    }

    public String get() {
        return this.sid;
    }

    public String toString() {
        return this.get();
    }

    @Override
    public String getValue() {
        return this.get();
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        return HdbInstOption.SID;
    }

    @Override
    public HdbUninstOption getHdbUninstOption() {
        return HdbUninstOption.SID;
    }

    private Result validate(String nameParam) {
        String name = nameParam.toUpperCase(Locale.ENGLISH).trim();
        if (name.length() != 3 && !"SYSTEMDB".equals(name)) {
            return new Result(false, name + " System ID  has to be 3 characters long!");
        }
        for (String s : RESERVED_SIDS) {
            if (!name.equals(s)) continue;
            return new Result(false, name + " System ID is not allowed!");
        }
        if (!Pattern.matches("^[A-Z]([A-Z0-9]+)$", name)) {
            return new Result(false, name + " System ID can only contain A-Z as first character and A-Z or 0-9 for the second and third character!");
        }
        this.sid = name;
        return new Result(true, "Sid is fine!");
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.parameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.parameterName = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof Sid) {
            String theirSid = o.toString();
            if (this.sid.equalsIgnoreCase(theirSid)) {
                equals = true;
            }
        } else if (o instanceof String) {
            String theirSid = new Sid((String)o).get();
            if (this.sid.equalsIgnoreCase(theirSid)) {
                equals = true;
            }
        } else {
            equals = super.equals(o);
        }
        return equals;
    }

    public boolean isValid() {
        Result result = this.validate(this.sid);
        return result.isValid();
    }

    public boolean isSystemDB() {
        boolean isSystemDB = false;
        if ("SYSTEMDB".equals(this.sid)) {
            isSystemDB = true;
        }
        return isSystemDB;
    }
}

