/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.Sid;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class StartStopScript {
    private FileName name = null;
    private Sid sid = null;
    private InstanceNumber instanceNumber = null;

    public StartStopScript(FileName name, Sid sid, InstanceNumber instanceNumber) {
        this.name = name;
        this.sid = sid;
        this.instanceNumber = instanceNumber;
    }

    public List<String> getContent() {
        ArrayList<String> content = new ArrayList<String>();
        content.add("#!/bin/sh");
        content.add(this.getCallString());
        content.add("result=$?");
        content.add("exit $result");
        return content;
    }

    private String getCallString() {
        String callString = "/usr/sap/" + this.sid.get() + "/HDB" + this.instanceNumber.get() + "/HDB " + this.getOption();
        return callString;
    }

    private String getOption() {
        String option = null;
        switch (this.name) {
            case STARTDB: 
            case STARTJ2EEDB: {
                option = "start";
                break;
            }
            case STOPDB: 
            case STOPJ2EEDB: {
                option = "stop";
                break;
            }
            default: {
                throw new HdbException((Object)((Object)this.name) + " not a valid name!");
            }
        }
        return option;
    }

    public File get() {
        File fileName = new File(this.name.toString().toLowerCase(Locale.ENGLISH));
        return fileName;
    }

    public static enum FileName {
        STARTDB,
        STOPDB,
        STARTJ2EEDB,
        STOPJ2EEDB;

    }
}

