/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StrFileForInvertedHashKey {
    private Map<String, String> statements = new HashMap<String, String>();
    private String sqlFileName = "";
    private int numberOfColumnTables = 0;
    private int numberOfRowTables = 0;
    private int oneIndexField = 0;

    public StrFileForInvertedHashKey(File strFile) {
        ArrayList<String> indexFields = new ArrayList<String>();
        String tableName = "";
        boolean newTable = false;
        boolean isColumnTable = false;
        FileReader fileReader = this.getReader(strFile);
        BufferedReader reader = new BufferedReader(fileReader);
        String line = this.readLine(reader);
        while (null != line) {
            if (line.startsWith("tab:")) {
                newTable = true;
                tableName = this.getAttributes(line)[1].trim();
            } else if (line.startsWith("att:") && (line.contains(" Tc ") || line.contains("Cc") || line.contains("Rc") || line.contains("Pc"))) {
                isColumnTable = true;
                ++this.numberOfColumnTables;
                this.setSqlFileName(line);
            } else if (line.startsWith("att:") && (line.contains(" Tr ") || line.contains("Cr") || line.contains("Rr") || line.contains("Pc"))) {
                ++this.numberOfRowTables;
            } else if (isColumnTable && line.startsWith("fld:")) {
                int fieldCounter;
                String[] splits = this.getAttributes(line);
                if (splits.length > 2 && (fieldCounter = this.getFieldCounter(splits[splits.length - 1])) > 0) {
                    indexFields.add(splits[1]);
                }
            } else if (newTable && isColumnTable && line.isEmpty()) {
                if (indexFields.size() > 1) {
                    String statement = "sql: ALTER TABLE \"" + tableName + "\" ADD PRIMARY KEY INVERTED HASH (";
                    int counter = 1;
                    for (String field : indexFields) {
                        statement = statement + "\"" + field + "\"";
                        if (counter < indexFields.size()) {
                            statement = statement + ",";
                        }
                        ++counter;
                    }
                    statement = statement + ");";
                    this.statements.put(tableName, statement);
                } else {
                    ++this.oneIndexField;
                }
                newTable = false;
                isColumnTable = false;
                indexFields = new ArrayList();
            }
            line = this.readLine(reader);
        }
        this.closeReader(fileReader, reader);
    }

    private void closeReader(FileReader fileReader, BufferedReader reader) {
        try {
            reader.close();
            fileReader.close();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
    }

    private int getFieldCounter(String string) {
        int result = 0;
        try {
            result = Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
        }
        return result;
    }

    private void setSqlFileName(String line) {
        String[] splits;
        if (this.sqlFileName.isEmpty() && (splits = this.getAttributes(line)).length > 2) {
            this.sqlFileName = splits[1] + ".SQL";
        }
    }

    private String[] getAttributes(String line) {
        String regexp = " ";
        String[] splits = line.split(regexp);
        if (splits.length < 2) {
            throw new HdbException(line + ", Error during split of line using regexp: '" + regexp + "'");
        }
        return splits;
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
    }

    private FileReader getReader(File strFile) {
        try {
            return new FileReader(strFile);
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e);
        }
    }

    public String getSqlFileName() {
        return this.sqlFileName;
    }

    public Map<String, String> getSqlFileContent() {
        return this.statements;
    }

    public int getNumberOfColumnTables() {
        return this.numberOfColumnTables;
    }

    public int getNumberOfRowTables() {
        return this.numberOfRowTables;
    }

    public int numberOfTablesWithOneIndexField() {
        return this.oneIndexField;
    }
}

